/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.profiler;

import java.io.Serializable;
import org.conqat.engine.persistence.store.profiler.StorageProfiler;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class StoreOperationStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long keysInOperation;
    private long valueBytesRead;
    private long keyBytesRead;
    private long numberOfOperationInvocations;
    private long operationDurationNanos;

    public StoreOperationStatistics(long durationNanos, long keysInOperation, long valueBytesRead, long numberOfOperationInvocations, long keyBytesRead) {
        this.operationDurationNanos = durationNanos;
        this.keysInOperation = keysInOperation;
        this.valueBytesRead = valueBytesRead;
        this.numberOfOperationInvocations = numberOfOperationInvocations;
        this.keyBytesRead = keyBytesRead;
    }

    public StoreOperationStatistics(StoreOperationStatistics old) {
        this(old.operationDurationNanos, old.keysInOperation, old.valueBytesRead, old.numberOfOperationInvocations, old.keyBytesRead);
    }

    public StoreOperationStatistics aggregate(StoreOperationStatistics other) {
        this.keysInOperation += other.keysInOperation;
        this.valueBytesRead += other.valueBytesRead;
        this.numberOfOperationInvocations += other.numberOfOperationInvocations;
        this.keyBytesRead += other.keyBytesRead;
        this.operationDurationNanos += other.operationDurationNanos;
        return this;
    }

    public long getOperationDurationMs() {
        return StorageProfiler.toMilliseconds(this.operationDurationNanos);
    }

    public long getKeyBytesRead() {
        return this.keyBytesRead;
    }

    public long getKeysInOperation() {
        return this.keysInOperation;
    }

    public long getValueBytesRead() {
        return this.valueBytesRead;
    }

    public long getNumberOfOperations() {
        return this.numberOfOperationInvocations;
    }
}

