/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ESchedulerCommand;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.service.admin.ServerRenderedPageServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/scheduler")
public class SchedulerControlService
extends ServerRenderedPageServiceBase {
    @GET
    @Operation(summary="Open scheduler control page", description="Provides a UI to send a command to the scheduler control.", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/html"})
    public String getSchedulerControlPage() {
        return this.buildHttpFormPage();
    }

    @POST
    @Operation(summary="Execute scheduler command", description="Allows to pass a command to the scheduler. The command is appended to the URL and should be one of the values from ESchedulerCommand. Note that using this service may harm the stability and data integrity of your instance.", tags={"System"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void executeSchedulerCommand(@FormParam(value="command") ESchedulerCommand command) throws StorageException {
        if (Objects.requireNonNull(command) != ESchedulerCommand.RELOAD) {
            throw new UnsupportedOperationException("Command " + command.name() + " is not supported.");
        }
        ISchedulerCommunicator.getInstance().sendReloadCommand(this.serviceInfo.getMessageBroker(), null);
    }
}

