/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.backup;

import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.index.backup.snapshot.StorageSnapshotExportTrigger;
import com.teamscale.service.admin.backup.SnapshotBackupServiceApi;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.capability.ISnapshotBackupCapability;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/storage-snapshot")
public class StorageSnapshotBackupService
extends ApiBase
implements SnapshotBackupServiceApi {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public boolean isSnapshotBackupSupported() {
        return this.serviceInfo.getIndexLayer().getRawStorageSystemProvider().getCapability(ISnapshotBackupCapability.class).isPresent();
    }

    @Override
    public Response triggerSnapshotBackup(String targetUri) throws StorageException {
        this.serviceInfo.getIndexLayer().getRawStorageSystemProvider().getCapability(ISnapshotBackupCapability.class).orElseThrow(() -> new BadRequestException("Storage system does not support snapshot backups!"));
        if (StringUtils.isEmpty((String)targetUri)) {
            throw new BadRequestException("Missing target URI for storage snapshot backup!");
        }
        LOGGER.warn("Attemption to store a storage snapshot at " + targetUri + ". Please check the worker log for progress and possible errors.");
        ISchedulerCommunicator.getInstance().scheduleMaintenanceTrigger(StorageSnapshotExportTrigger.class, targetUri, "Scheduled by service call via user " + this.getUser().getFullName(), this.getIndexLayer());
        return this.createRedirectResponseBuilder("system.html").build();
    }
}

