/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.sap;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.service.admin.sap.SapSystemIdNotFoundException;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Optional;
import javax.naming.NoPermissionException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/sap-system-id-by-project")
public class SapSystemIdByProjectLookupService
extends ApiBase {
    @GET
    @Path(value="{projectId}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0)
    @Operation(summary="Get the SAP system ID corresponding to given project.", description="Looks up the SAP System ID by the Teamscale project.", tags={"SAP", "Project"})
    @RequiresNoPermission(description="The service will only search among projects visible to current user.")
    public String lookupSapSystemIdByProjectId(@Parameter(description="ID of the Teamscale project") @PathParam(value="projectId") String projectId) throws StorageException, NoPermissionException {
        IndexLayer indexLayer = this.getIndexLayer();
        ProjectInfo info = indexLayer.resolveProject((IProjectId)PublicProjectId.of((String)projectId));
        if (!this.getPermissions().getVisibleProjects().contains(info)) {
            throw new NoPermissionException("No permission to access the project " + projectId);
        }
        Optional systemId = AbapProjectUtils.getSapSystemIdFromConnector((ProjectInfo)info, (IndexLayer)indexLayer);
        if (systemId.isEmpty()) {
            throw new SapSystemIdNotFoundException("Couldn't find a SAP system id for the project " + projectId);
        }
        return (String)systemId.get();
    }
}

