/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.architecture.external.ArchitectureUploadInfo;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.BranchCommitReadingStore;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/external-uploads/architectures")
public class ArchitectureExternalUploadInfoService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all architectures with commit count", description="Returns architecture uniform paths and the number of commits per architecture for the project.", tags={"Architecture"})
    public List<ArchitectureWithCommitCount> getArchitectures(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem((IProjectId)projectId);
        IStore uploadStore = projectStorageSystem.openStoreChecked("external-architecture-uploads", ExternalArchitectureUploadIndex.class, (IStorageSystem)projectStorageSystem, true, null);
        Map uniformPathToCommitCount = ArchitectureExternalUploadInfoService.extractArchitectureUploadInfoList(new CommitLayeringBranchingLayer(uploadStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout())).stream().flatMap(upload -> upload.architectureUploadInfo.getUniformPaths().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return uniformPathToCommitCount.entrySet().stream().map(i -> new ArchitectureWithCommitCount((String)i.getKey(), (Long)i.getValue())).sorted(Comparator.comparing(info -> info.uniformPath)).collect(Collectors.toList());
    }

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{architecture}/commits")
    @Operation(summary="Get all architecture upload infos", description="Returns architecture upload infos for the project.", tags={"Architecture"})
    public List<CommitWithUserName> getArchitectureCommitUploadInfos(@PathParam(value="architecture") UniformPath architecture) throws StorageException {
        return ArchitectureExternalUploadInfoService.extractArchitectureUploadInfoListForPath(architecture, this.openCommitLayeringBranchingLayer()).stream().map(upload -> {
            EUploadCommitType commitType = EUploadCommitType.ADD_EDIT;
            if (upload.architectureUploadInfo.getDeletedArchitectures().contains(architecture.toString())) {
                commitType = EUploadCommitType.DELETE;
            }
            return new CommitWithUserName(upload.commit, upload.architectureUploadInfo.getUsername(), commitType);
        }).sorted(Comparator.comparing(CommitWithUserName::getTimestamp).reversed()).collect(Collectors.toList());
    }

    static List<ArchitectureCommitUploadInfo> extractArchitectureUploadInfoListForPath(UniformPath architecture, CommitLayeringBranchingLayer uploadBranchingLayer) throws StorageException {
        return CollectionUtils.filter(ArchitectureExternalUploadInfoService.extractArchitectureUploadInfoList(uploadBranchingLayer), upload -> upload.architectureUploadInfo.getUniformPaths().contains(architecture.toString()) || upload.architectureUploadInfo.getDeletedArchitectures().contains(architecture.toString()));
    }

    @GET
    @Path(value="{commit}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get architecture upload info", description="Returns architecture upload info for the specified commit.", tags={"Architecture"}, responses={@ApiResponse(responseCode="204", description="The commit does not exist.")})
    public @Nullable ArchitectureCommitUploadInfo getArchitectureCommitUploadInfo(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @PathParam(value="commit") UnresolvedCommitDescriptor commit) throws StorageException {
        CommitLayeringBranchingLayer uploadBranchingLayer = this.openCommitLayeringBranchingLayer();
        return ArchitectureExternalUploadInfoService.extractArchitectureUploadInfo(uploadBranchingLayer, this.resolve(commit));
    }

    private static @Nullable ArchitectureCommitUploadInfo extractArchitectureUploadInfo(CommitLayeringBranchingLayer uploadBranchingLayer, CommitDescriptor artificialCommit) throws StorageException {
        IBranchCommitInfo branchCommitInfo = uploadBranchingLayer.getNewestCommitBeforeOrAt(artificialCommit.getBranchName(), artificialCommit.getTimestamp());
        if (branchCommitInfo == null) {
            return null;
        }
        return ArchitectureExternalUploadInfoService.extractArchitectureCommitUploadInfo(uploadBranchingLayer, branchCommitInfo.getBranchName(), branchCommitInfo.getTimestamp());
    }

    public static List<ArchitectureCommitUploadInfo> extractArchitectureUploadInfoList(CommitLayeringBranchingLayer uploadBranchingLayer) throws StorageException {
        ArrayList<ArchitectureCommitUploadInfo> architectureUploadInfoList = new ArrayList<ArchitectureCommitUploadInfo>();
        PairList allBranchNamesAndTimestamps = uploadBranchingLayer.getAllBranchNamesAndTimestamps();
        for (int i = 0; i < allBranchNamesAndTimestamps.size(); ++i) {
            architectureUploadInfoList.add(ArchitectureExternalUploadInfoService.extractArchitectureCommitUploadInfo(uploadBranchingLayer, (String)allBranchNamesAndTimestamps.getFirst(i), (Long)allBranchNamesAndTimestamps.getSecond(i)));
        }
        return architectureUploadInfoList;
    }

    private CommitLayeringBranchingLayer openCommitLayeringBranchingLayer() throws StorageException {
        IStore uploadStore = this.openStoreInProject("external-architecture-uploads", ExternalArchitectureUploadIndex.class);
        return new CommitLayeringBranchingLayer(uploadStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
    }

    public static ArchitectureCommitUploadInfo extractArchitectureCommitUploadInfo(CommitLayeringBranchingLayer uploadBranchingLayer, String branchName, long timestamp) throws StorageException {
        BranchCommitReadingStore branchedView = uploadBranchingLayer.createExactCommitReadingStore(CommitLayeringBranchingLayer.createCommitName((String)branchName, (long)timestamp));
        ArchitectureUploadInfo commitInfo = (ArchitectureUploadInfo)new ExternalArchitectureUploadIndex((IStore)branchedView).getCommitInfo();
        return new ArchitectureCommitUploadInfo(commitInfo, new CommitDescriptor(branchName, timestamp));
    }

    public static class ArchitectureCommitUploadInfo {
        private static final String ARCHITECTURE_UPLOAD_INFO_PROPERTY = "architectureUploadInfo";
        private static final String COMMIT_PROPERTY = "commit";
        @JsonProperty(value="architectureUploadInfo")
        public final ArchitectureUploadInfo architectureUploadInfo;
        @JsonProperty(value="commit")
        public final CommitDescriptor commit;

        @JsonCreator
        public ArchitectureCommitUploadInfo(@JsonProperty(value="architectureUploadInfo") ArchitectureUploadInfo architectureUploadInfo, @JsonProperty(value="commit") CommitDescriptor commit) {
            this.architectureUploadInfo = architectureUploadInfo;
            this.commit = commit;
        }
    }

    @ExportToTypeScript
    public static enum EUploadCommitType {
        ADD_EDIT("add/edit"),
        DELETE("delete");

        private final String readableName;

        private EUploadCommitType(String readableName) {
            this.readableName = readableName;
        }
    }

    public static class CommitWithUserName {
        private static final String COMMIT_TYPE_PROPERTY = "commitType";
        @JsonProperty(value="commitType")
        private final EUploadCommitType commitType;
        @JsonProperty(value="branchName")
        private final String branchName;
        @JsonProperty(value="timestamp")
        private final long timestamp;
        @JsonProperty(value="userName")
        private final String userName;

        @JsonCreator
        @VisibleForTesting
        private CommitWithUserName() {
            this.commitType = null;
            this.branchName = null;
            this.userName = null;
            this.timestamp = 0L;
        }

        private CommitWithUserName(CommitDescriptor commit, String userName, EUploadCommitType commitType) {
            this.branchName = commit.getBranchName();
            this.timestamp = commit.getTimestamp();
            this.userName = userName;
            this.commitType = commitType;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getBranchName() {
            return this.branchName;
        }
    }

    private record ArchitectureWithCommitCount(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="commitCount") long commitCount) {
    }
}

