/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.service.audit.FileGroup;
import com.teamscale.service.audit.FilesWithIdenticalPropertyServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/audit/files-with-identical-content/{uniformPath: .*}")
public class FilesWithIdenticalContentService
extends FilesWithIdenticalPropertyServiceBase {
    private static final String PARAM_NAME_IGNORE_WHITESPACES = "ignoreWhitespaces";
    private boolean isIgnoreWhitespaces;
    private HistoryAccessOption historyAccessOption;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get files with an identical content", description="Retrieves files.", tags={"Audit"}, responses={@ApiResponse(responseCode="204", description="No data available")})
    public List<FileGroup> getFilesWithIdenticalContent(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="regex") String regexFilter, @QueryParam(value="ignoreWhitespaces") @DefaultValue(value="true") boolean isIgnoreWhitespaces) throws StorageException {
        this.historyAccessOption = this.determineHistoryOption(commit);
        this.isIgnoreWhitespaces = isIgnoreWhitespaces;
        return this.findFilesWithIdenticalProperties(regexFilter, this.historyAccessOption, uniformPath);
    }

    @Override
    protected Map<String, Set<UniformPath>> groupPaths(List<UniformPath> uniformPaths) throws StorageException {
        HashMap<String, Set<UniformPath>> uniformPathsByContentHash = new HashMap<String, Set<UniformPath>>();
        TokenElementIndex tokenElementIndex = TokenElementIndex.open((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)this.historyAccessOption);
        for (UniformPath path : uniformPaths) {
            String hashValue = this.computeHash(path, tokenElementIndex);
            uniformPathsByContentHash.computeIfAbsent(hashValue, x -> new HashSet()).add(path);
        }
        return uniformPathsByContentHash;
    }

    private String computeHash(UniformPath path, TokenElementIndex tokenElementIndexForCode) throws StorageException {
        String content = this.fetchCode(path, tokenElementIndexForCode);
        return FilesWithIdenticalContentService.computeHash(content, this.isIgnoreWhitespaces);
    }

    @VisibleForTesting
    protected static String computeHash(String content, boolean isIgnoreWhitespaces) {
        if (isIgnoreWhitespaces) {
            content = StringUtils.removeWhitespace((String)content);
        }
        return "XXhash64-" + Long.toHexString(XXHashUtils.xxhash64((String)content));
    }

    private String fetchCode(UniformPath path, TokenElementIndex tokenElementIndexForCode) throws StorageException {
        TokenElementIndex elementIndexToUse = tokenElementIndexForCode;
        if (!path.isCodePath()) {
            elementIndexToUse = ResourceServiceUtils.openContentIndex((UniformPath)path, (HistoryAccessOption)this.historyAccessOption, (ProjectStorageSystem)this.getProjectStorageSystem());
        }
        return elementIndexToUse.getTokenElementByPath(path).getText();
    }
}

