/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseIndex;
import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseInfo;
import com.teamscale.index.audit.analysis.copyrightlicense.ELicenseType;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class LicenseTreeMapBuilder
extends MetricTreemapBuilderBase<TreeMapNode> {
    private FilteredTreeMapWrapper treemapWrapper;
    private TreeMapNode treemap;
    private final CopyrightLicenseIndex licenseIndex;
    private final Set<String> customerLicenses;

    protected LicenseTreeMapBuilder(Pattern includePattern, Pattern excludePattern, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, int colorMetricIndex, Object colorMetricDefault, Color baseColor, Set<String> customerLicenses, CopyrightLicenseIndex licenseIndex) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex, new MetricTreemapBuilderParameters(includePattern, excludePattern, colorMetricIndex, colorMetricDefault, baseColor));
        this.customerLicenses = customerLicenses;
        this.licenseIndex = licenseIndex;
    }

    protected FilteredTreeMapWrapper getWrapper(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        this.treemap = this.buildTreeMap(uniformPath);
        this.treemapWrapper.setTreemap(this.treemap);
        return this.treemapWrapper;
    }

    @Override
    protected void afterEntryPreparation(List<MetricDirectoryEntry> entries) throws StorageException {
        int filesIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Files");
        int locIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Lines of Code");
        int overallFiles = (int)entries.get(0).getDoubleValue(filesIndex);
        int affectedFiles = 0;
        int affectedLoc = 0;
        ArrayList<String> affectedPaths = new ArrayList<String>();
        List cleanPaths = CollectionUtils.map(entries, entry -> UniformPathCompatibilityUtil.resolveToCodePath((String)entry.getUniformPath()));
        List licenseInfos = this.licenseIndex.getCopyrightLicenseInfo(cleanPaths);
        for (int i = 0; i < entries.size(); ++i) {
            MetricDirectoryEntry entry2 = entries.get(i);
            CopyrightLicenseInfo licenseInfo = (CopyrightLicenseInfo)licenseInfos.get(i);
            if (licenseInfo == null || licenseInfo.getLicenseType() == ELicenseType.UNDEFINED || this.determineColor(licenseInfo).equals(Color.LIGHT_GRAY)) continue;
            ++affectedFiles;
            affectedLoc += (int)entry2.getDoubleValue(locIndex);
            affectedPaths.add(licenseInfo.getUniformPath());
        }
        this.treemapWrapper = new FilteredTreeMapWrapper(affectedPaths, this.treemap, overallFiles, affectedLoc, affectedFiles, affectedFiles);
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException {
        String cleanPath = UniformPathCompatibilityUtil.resolveToCodePath((String)entry.getUniformPath());
        CopyrightLicenseInfo licenseInfo = this.licenseIndex.getCopyrightLicenseInfo(cleanPath);
        return new TreeMapNode(entry.getUniformPath(), entry.getDoubleValue(this.areaMetricIndex), this.determineLicenseName(licenseInfo), this.determineColor(licenseInfo));
    }

    private String determineLicenseName(CopyrightLicenseInfo licenseInfo) {
        if (licenseInfo == null) {
            return ELicenseType.UNDEFINED.toString();
        }
        if (licenseInfo.getLicenseType() != ELicenseType.UNDEFINED) {
            return licenseInfo.getLicenseType().toString();
        }
        ArrayList<String> matchingLicenses = new ArrayList<String>();
        for (String customerLicense : this.customerLicenses) {
            if (!licenseInfo.getComment().contains(customerLicense)) continue;
            matchingLicenses.add(customerLicense);
        }
        if (!matchingLicenses.isEmpty()) {
            return StringUtils.concat(matchingLicenses, (String)",");
        }
        return ELicenseType.UNDEFINED.toString();
    }

    private Color determineColor(CopyrightLicenseInfo licenseInfo) {
        if (licenseInfo == null) {
            return Color.WHITE;
        }
        if (StringUtils.containsOneOf((String)licenseInfo.getComment(), this.customerLicenses)) {
            return Color.LIGHT_GRAY;
        }
        if (licenseInfo.getLicenseType() != ELicenseType.UNDEFINED) {
            return licenseInfo.getLicenseType().getColor();
        }
        return ELicenseType.UNDEFINED.getColor();
    }
}

