/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/project-files")
public class ProjectFilesService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="snapshot.zip")
    @Operation(summary="Get all project files", description="Retrieves all files of a project as a ZIP file.", tags={"Audit"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Response getAllProjectFiles(@Parameter(description="Uniform path to retrieve files for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Whether the files of the source library connector should be included.") @QueryParam(value="include-source-library-connectors") @DefaultValue(value="false") boolean includeSourceLibraryConnectors) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        BinaryElementIndex binaryElementIndex = this.openProjectIndex(BinaryElementIndex.class, historyOption);
        BasicTokenElementIndex basicTokenElementIndex = this.openProjectIndex(BasicTokenElementIndex.class, historyOption);
        List<String> filePaths = this.determineFilePaths(uniformPath, commit, includeSourceLibraryConnectors);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            Response response;
            try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream((OutputStream)outputStream);){
                zipOutputStream.setUseZip64(Zip64Mode.Always);
                for (String filePath : filePaths) {
                    byte[] fileBytes = ProjectFilesService.getFileContentAsBytes(filePath, basicTokenElementIndex, binaryElementIndex);
                    if (fileBytes == null) continue;
                    ZipArchiveEntry zipEntry = new ZipArchiveEntry(filePath);
                    zipOutputStream.putArchiveEntry(zipEntry);
                    zipOutputStream.write(fileBytes);
                    zipOutputStream.closeArchiveEntry();
                }
                zipOutputStream.close();
                byte[] entity = outputStream.toByteArray();
                String fileName = String.valueOf(this.serviceInfo.getPrimaryPublicId()) + "_all_files.zip";
                response = ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)fileName);
            }
            return response;
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Could not create zip file for download", (Throwable)e);
        }
    }

    private static byte @Nullable [] getFileContentAsBytes(String filePath, BasicTokenElementIndex contentIndex, BinaryElementIndex binaryElementIndex) throws StorageException {
        BasicTokenElementInfo element = contentIndex.getTokenElement(filePath);
        if (element == null) {
            LOGGER.error("Could not retrieve element for " + filePath + ". Skipping this file.");
            return null;
        }
        if (element.getLanguage() == ELanguage.SIMULINK) {
            byte[] fileBytes = binaryElementIndex.getContent(filePath);
            if (fileBytes == null) {
                LOGGER.error("Could not retrieve binary content for " + element.getUniformPath() + ". Skipping this file.");
                return null;
            }
            return fileBytes;
        }
        return element.getText().getBytes(StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="file-paths.csv")
    @Operation(summary="Get all project file paths", description="Retrieves all files paths of a project as a CSV file.", tags={"Audit"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Response getAllProjectFilePaths(@Parameter(description="Uniform path to retrieve files for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Whether the files of the source library connector should be included.") @QueryParam(value="include-source-library-connectors") @DefaultValue(value="false") boolean includeSourceLibraryConnectors) throws StorageException {
        List<String> filePaths = this.determineFilePaths(uniformPath, commit, includeSourceLibraryConnectors);
        try (StringWriter stringWriter = new StringWriter();){
            Response response;
            try (BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);){
                for (String filePath : filePaths) {
                    bufferedWriter.write(filePath);
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
                String entity = stringWriter.toString();
                String fileName = String.valueOf(this.serviceInfo.getPrimaryPublicId()) + "_all_file_paths.csv";
                response = ResponseUtils.getFileDownloadResponse((Object)entity, (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)fileName);
            }
            return response;
        }
        catch (IOException exception) {
            throw new InternalServerErrorException((Throwable)exception);
        }
    }

    private List<String> determineFilePaths(UniformPath path, UnresolvedCommitDescriptor commit, boolean includeLibraryConnectors) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        MetricsToArchitectureMetricsMappingIndex metricsToArchitectureMetricsMappingIndex = this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyOption);
        if (includeLibraryConnectors) {
            BasicTokenElementIndex contentIndex = this.openProjectIndex(BasicTokenElementIndex.class, historyOption);
            return ProjectFilesService.determineFilePaths(path, (FunctionWithException<String, List<String>, StorageException>)((FunctionWithException)arg_0 -> ((BasicTokenElementIndex)contentIndex).getUniformPathsStartingWith(arg_0)), metricsToArchitectureMetricsMappingIndex);
        }
        TokenElementIndex contentIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyOption);
        return ProjectFilesService.determineFilePaths(path, (FunctionWithException<String, List<String>, StorageException>)((FunctionWithException)arg_0 -> ((TokenElementIndex)contentIndex).getUniformPathsStartingWith(arg_0)), metricsToArchitectureMetricsMappingIndex);
    }

    public static List<String> determineFilePaths(UniformPath path, FunctionWithException<String, List<String>, StorageException> indexPathPrefixFunction, MetricsToArchitectureMetricsMappingIndex metricsToArchitectureMetricsMappingIndex) throws StorageException {
        String uniformPath = path.toString();
        if (!uniformPath.isEmpty()) {
            uniformPath = StringUtils.ensureEndsWith((String)uniformPath, (String)"/");
        }
        if (ArchitectureMetricsUtils.isArchitectureArtifactPath((String)uniformPath)) {
            return CollectionUtils.sort((Collection)ArchitectureMetricsUtils.getLeafPaths((MetricsToArchitectureMetricsMappingIndex)metricsToArchitectureMetricsMappingIndex, (String)uniformPath));
        }
        return (List)indexPathPrefixFunction.apply((Object)uniformPath);
    }
}

