/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.audit.RedundantLiteralService;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import com.teamscale.service.metrics.treemap.builder.TreemapBuilderBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class RedundantLiteralTreeMapBuilder
extends TreemapBuilderBase<TreeMapNode> {
    private final Map<String, CounterSet<String>> fileToLiteralCount = new HashMap<String, CounterSet<String>>();
    private int maxLiteralInSingleFile = 1;
    private FilteredTreeMapWrapper treemapWrapper;
    private TreeMapNode treemap;
    private final boolean isColorGradationActive;

    public RedundantLiteralTreeMapBuilder(IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, List<RedundantLiteralService.RedundantLiteralInfo> infos, boolean isColorGradationActive) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex);
        this.isColorGradationActive = isColorGradationActive;
        for (RedundantLiteralService.RedundantLiteralInfo info : infos) {
            for (String file : info.getFiles()) {
                if (!this.fileToLiteralCount.containsKey(file)) {
                    this.fileToLiteralCount.put(file, (CounterSet<String>)new CounterSet());
                }
                this.fileToLiteralCount.get(file).inc((Object)info.getLiteral());
            }
        }
    }

    protected FilteredTreeMapWrapper getWrapper(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        this.treemap = this.buildTreeMap(uniformPath);
        this.treemapWrapper.setTreemap(this.treemap);
        return this.treemapWrapper;
    }

    private boolean pathHasRedundantLiterals(String path) {
        return this.fileToLiteralCount.keySet().stream().anyMatch(file -> file.startsWith(path));
    }

    @Override
    protected void determineValueRange(List<MetricDirectoryEntry> entries) {
        this.maxLiteralInSingleFile = this.fileToLiteralCount.values().stream().map(CounterSet::getTotal).max(Comparator.naturalOrder()).orElse(1);
    }

    @Override
    protected void afterEntryPreparation(List<MetricDirectoryEntry> entries) throws StorageException {
        int filesIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Files");
        int locIndex = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getValuePosition("Lines of Code");
        int overallFiles = (int)entries.get(0).getDoubleValue(filesIndex);
        int affectedFiles = 0;
        int affectedLoc = 0;
        int overallHits = 0;
        ArrayList<String> affectedPaths = new ArrayList<String>();
        for (MetricDirectoryEntry entry : entries) {
            String cleanPath = UniformPathCompatibilityUtil.resolveToCodePath((String)entry.getUniformPath());
            CounterSet<String> literalCounter = this.getAggredatedLiteralCountForPath(cleanPath);
            if (!this.pathHasRedundantLiterals(cleanPath) || !this.fileToLiteralCount.containsKey(cleanPath)) continue;
            ++affectedFiles;
            affectedLoc += (int)entry.getDoubleValue(locIndex);
            overallHits += literalCounter.getTotal();
            affectedPaths.add(entry.getUniformPath());
        }
        this.treemapWrapper = new FilteredTreeMapWrapper(affectedPaths, this.treemap, overallFiles, affectedLoc, affectedFiles, overallHits);
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) {
        Object searchResult = "No redundant literals found.";
        double relativeValue = 0.0;
        int total = 0;
        String cleanPath = UniformPathCompatibilityUtil.resolveToCodePath((String)entry.getUniformPath());
        if (this.pathHasRedundantLiterals(cleanPath)) {
            CounterSet<String> literalCounter = this.getAggredatedLiteralCountForPath(cleanPath);
            total = literalCounter.getTotal();
            searchResult = total + " redundant literals";
            if (this.fileToLiteralCount.containsKey(cleanPath)) {
                relativeValue = (double)total * 1.0 / (double)this.maxLiteralInSingleFile;
            }
        }
        Color nodeColor = Color.WHITE;
        if (this.isColorGradationActive) {
            nodeColor = ColorUtils.blend((double)relativeValue, (Color)Color.BLUE, (Color)Color.WHITE);
        } else if (total != 0) {
            nodeColor = Color.BLUE;
        }
        return new TreeMapNode(entry.getUniformPath(), entry.getDoubleValue(this.areaMetricIndex), (String)searchResult, nodeColor);
    }

    private CounterSet<String> getAggredatedLiteralCountForPath(String uniformPath) {
        CounterSet literalCounter = new CounterSet();
        for (Map.Entry<String, CounterSet<String>> entry : this.fileToLiteralCount.entrySet()) {
            if (!entry.getKey().startsWith(uniformPath)) continue;
            literalCounter.add(entry.getValue());
        }
        return literalCounter;
    }
}

