/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileUtils;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.commits.RepositoryLogFilter;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/repository-logs")
public class RepositoryLogListingService
extends ApiBase {
    private static final String COMMIT_DESCRIPTION_TEXT = "A commit is identified as branch1@timestamp1All timestamps are interpreted as milliseconds since 1970. If no commits are provided, all log entries are returned. Commits are separated by comma.";
    private static final String PRIVACY_AWARE_PARAMETER = "privacy-aware";
    private static final String PRIVACY_AWARE_PARAMETER_DOC = "Optional parameter that controls whether only repository log \tentries are returned where the current user was the committer. This defaults to false.";
    @QueryParam(value="privacy-aware")
    @Parameter(description="Optional parameter that controls whether only repository log \tentries are returned where the current user was the committer. This defaults to false.")
    private boolean isPrivacyAware;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all repository log entries", description="Returns repository log entries for given commits.A commit is identified as branch1@timestamp1All timestamps are interpreted as milliseconds since 1970. If no commits are provided, all log entries are returned. Commits are separated by comma.")
    public List<ExtendedRepositoryLogEntry> getRepositoryLog(@QueryParam(value="commit") List<UnresolvedCommitDescriptor> commits, @QueryParam(value="merge-request-id") @Nullable String mergeRequestId, @BeanParam RepositoryLogFilter repositoryLogFilter) throws StorageException {
        List<CommitDescriptor> commitDescriptors = this.resolveCommits(commits);
        List<RepositoryLogEntryAggregate> result = this.getPrivacyAwareResult(commitDescriptors);
        List<ExtendedRepositoryLogEntry> extendedRepositoryLogEntries = LogEntryResolver.of(this.serviceInfo).resolveRepositoryLogEntryAggregatesAsAggregatedEntries(result, mergeRequestId);
        return this.tryFilter(extendedRepositoryLogEntries, repositoryLogFilter, commitDescriptors);
    }

    @GET
    @Path(value="count")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get the number of all repository log entries", description="Returns the number of repository log entries for given commits.A commit is identified as branch1@timestamp1All timestamps are interpreted as milliseconds since 1970. If no commits are provided, all log entries are returned. Commits are separated by comma.")
    public int getRepositoryLogCount(@QueryParam(value="commit") List<UnresolvedCommitDescriptor> commits, @QueryParam(value="merge-request-id") @Nullable String mergeRequestId) throws StorageException {
        List<CommitDescriptor> commitDescriptors = this.resolveCommits(commits);
        List<RepositoryLogEntryAggregate> result = this.getPrivacyAwareResult(commitDescriptors);
        return LogEntryResolver.of(this.serviceInfo).resolveRepositoryLogEntryAggregatesAsAggregatedEntries(result, mergeRequestId).size();
    }

    @GET
    @Path(value="split")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all repository log entries, with split aggregates", description="Returns repository log entries for given commits. Aggregated entries are split into their constituents.A commit is identified as branch1@timestamp1All timestamps are interpreted as milliseconds since 1970. If no commits are provided, all log entries are returned. Commits are separated by comma.")
    public List<ExtendedRepositoryLogEntry> getRepositoryLogWithSplitAggregates(@QueryParam(value="commit") List<UnresolvedCommitDescriptor> commits, @QueryParam(value="merge-request-id") @Nullable String mergeRequestId, @BeanParam RepositoryLogFilter repositoryLogFilter) throws StorageException {
        List<CommitDescriptor> commitDescriptors = this.resolveCommits(commits);
        List<RepositoryLogEntryAggregate> result = this.getPrivacyAwareResult(commitDescriptors);
        List<ExtendedRepositoryLogEntry> extendedRepositoryLogEntries = LogEntryResolver.of(this.serviceInfo).resolveRepositoryLogEntryAggregatesAsSeparateEntries(result, mergeRequestId);
        return this.tryFilter(extendedRepositoryLogEntries, repositoryLogFilter, commitDescriptors);
    }

    protected RepositoryLogIndex getIndex() throws StorageException {
        return this.openProjectIndex(RepositoryLogIndex.class, null);
    }

    private List<RepositoryLogEntryAggregate> getPrivacyAwareResult(List<CommitDescriptor> commits) throws StorageException {
        List result = commits.isEmpty() ? this.getIndex().getEntries(1L, Long.MAX_VALUE) : this.getIndex().getEntries(commits);
        result.removeIf(Objects::isNull);
        if (this.isPrivacyAware) {
            result = RepositoryLogFileUtils.applyDataPrivacyFilterToLog((List)result, (GlobalStorageSystem)this.getGlobalStorageSystem(), (ServicePermissions)this.getPermissions(), (User)this.getUser(), (UserAliasLookup)UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()));
        }
        return result;
    }

    private List<ExtendedRepositoryLogEntry> tryFilter(List<ExtendedRepositoryLogEntry> extendedRepositoryLogEntries, RepositoryLogFilter repositoryLogFilter, List<CommitDescriptor> commitDescriptors) throws StorageException {
        if (commitDescriptors.isEmpty()) {
            return extendedRepositoryLogEntries;
        }
        this.setFilterOptions(repositoryLogFilter, commitDescriptors.get(0).getBranchName(), this.isPrivacyAware);
        return repositoryLogFilter.filter(extendedRepositoryLogEntries);
    }

    private void setFilterOptions(RepositoryLogFilter filter, String branchName, boolean privacyAware) throws StorageException {
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        filter.setFilteringOptions(Set.of(), userAliasLookup, branchName);
        filter.setPrivacyRelatedFilteringInfo(privacyAware, this.getGlobalStorageSystem(), this.getPermissions(), this.getUser());
    }
}

