/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.dashboard.templates.DashboardTemplateDescriptor;
import com.teamscale.index.dashboard.templates.DashboardTemplateIndex;
import com.teamscale.index.dashboard.templates.EDashboardTemplateDescriptorVersion;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.dashboard.UserResolvedDashboardTemplateDescriptor;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/dashboard-templates")
public class DashboardTemplateService
extends ApiBase {
    private static final String PARAM_DASHBOARD_DESCRIPTOR = "dashboard-template";
    public static final String FILE_EXTENSION_TEMPLATE = ".tstemplate";
    private static final String JSON_PROJECT_PATTERN = "(\"project\"\\s*:\\s*\")(.*?)(\")";
    private static final String JSON_PATH_PATTERN = "(\"path\"\\s*:\\s*\")(.*?)(\")";
    private static final Pattern JSON_TITLE_PATTERN = Pattern.compile("(\"Title\":\\s*\")(.*?)(\")");

    @GET
    @Path(value="{templateId}")
    @RequiresNoPermission(description="Any user may see dashboard templates.")
    @Operation(summary="Get dashboard template", description="Retrieves the dashboard template identified by the given ID.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="Template with given ID could not be found.")})
    public UserResolvedDashboardTemplateDescriptor getDashboardTemplateDescriptor(@Parameter(description="ID of the template to retrieve") @PathParam(value="templateId") UUID templateId) throws StorageException {
        return this.getDashboardTemplate(templateId);
    }

    @GET
    @RequiresNoPermission(description="Any user may see dashboard templates.")
    @Operation(summary="Get all dashboard templates", description="Retrieves all the dashboard templates available in the system.", tags={"Dashboards"})
    public List<UserResolvedDashboardTemplateDescriptor> getAllDashboardTemplates() throws StorageException {
        DashboardTemplateIndex dashboardTemplateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        return UserResolvedDashboardTemplateDescriptor.resolveUsers(dashboardTemplateIndex.getAllDashboardTemplates(), UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()), this.openGlobalIndex(PermissionIndex.class), this.getPermissions());
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_DASHBOARD_TEMPLATES})
    @Operation(summary="Create dashboard template", description="Creates a new dashboard template", tags={"Dashboards"})
    public UUID createDashboardTemplate(@RequestBody(required=true) DashboardTemplateDescriptor newTemplate) throws StorageException {
        if (newTemplate.getId() != null) {
            throw new BadRequestException("The dashboard template already has an ID. To update the existing dashboard use the PUT method.");
        }
        newTemplate.generateId();
        DashboardTemplateIndex dashboardTemplateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        newTemplate.setDescriptor(DashboardTemplateService.insertProjectPlaceholders(projectIndex, newTemplate.getDescriptor()));
        dashboardTemplateIndex.storeDashboardTemplate(newTemplate);
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.DASHBOARD_TEMPLATES, newTemplate.getId().toString());
        return newTemplate.getId();
    }

    @PUT
    @Path(value="{templateId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.DASHBOARD_TEMPLATES, entityPathParameter="templateId", permissions={EBasicPermission.EDIT})
    @Operation(summary="Update dashboard template", description="Updates the given dashboard template", tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="Template with given ID could not be found.")})
    public void updateDashboardTemplate(@Parameter(description="ID of the template to update") @PathParam(value="templateId") UUID templateId, @RequestBody(required=true) DashboardTemplateDescriptor newValue) throws StorageException {
        UserResolvedDashboardTemplateDescriptor oldTemplate = this.getDashboardTemplate(templateId);
        this.updateElement(oldTemplate, newValue);
    }

    @DELETE
    @Path(value="{templateId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.DASHBOARD_TEMPLATES, entityPathParameter="templateId", permissions={EBasicPermission.EDIT})
    @Operation(summary="Delete dashboard template", description="Deletes the dashboard template identified by the given ID.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="Template with given ID could not be found.")})
    public void deleteDashboardTemplate(@Parameter(description="ID of the template to delete") @PathParam(value="templateId") UUID templateId) throws StorageException {
        try {
            this.getDashboardTemplate(templateId);
        }
        catch (AssertionError e) {
            this.removeDashboardTemplate(templateId);
            return;
        }
        this.removeDashboardTemplate(templateId);
    }

    @POST
    @Path(value="import")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_DASHBOARD_TEMPLATES})
    @Operation(summary="Create a dashboard template", description="Performs an import of a dashboard template. Adds the uploaded descriptor to the list of templates. The descriptor must be packaged within an JSON Teamscale Version Container.", parameters={@Parameter(name="dashboard-template", description="Dashboard template description", content={@Content(mediaType="application/json", schema=@Schema(implementation=TeamscaleVersionContainer.class))})}, tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="No descriptor data given.")})
    @Consumes(value={"multipart/form-data"})
    public List<UUID> importDashboardTemplate(@Parameter(required=true) @ArraySchema(schema=@Schema(type="string", format="binary")) @FormDataParam(value="dashboard-template") List<String> dashboardDescriptors) throws StorageException, MigrationException {
        DashboardTemplateIndex dashboardTemplateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        ArrayList<UUID> importedFiles = new ArrayList<UUID>();
        for (String content : dashboardDescriptors) {
            UUID templateId = DashboardTemplateService.saveDashboardTemplate(content, dashboardTemplateIndex, true);
            this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.DASHBOARD_TEMPLATES, templateId.toString());
            importedFiles.add(templateId);
        }
        return importedFiles;
    }

    public static UUID saveDashboardTemplate(String templateJSON, DashboardTemplateIndex dashboardTemplateIndex, boolean generateNewId) throws StorageException, MigrationException {
        DashboardTemplateDescriptor templateDescriptor = (DashboardTemplateDescriptor)TeamscaleVersionContainer.fromJson((String)templateJSON, null, DashboardTemplateDescriptor.class, (Enum)EDashboardTemplateDescriptorVersion.CURRENT_VERSION, (String)"dashboard descriptor");
        CCSMAssert.isNotNull((Object)templateDescriptor);
        if (generateNewId) {
            templateDescriptor.generateId();
        }
        dashboardTemplateIndex.storeDashboardTemplate(templateDescriptor);
        return templateDescriptor.getId();
    }

    @GET
    @Path(value="{templateId}/export")
    @RequiresNoPermission
    @Operation(summary="Get a dashboard template", description="Performs an export of a dashboard template. Returns the template as a .tstemplate file.", tags={"Dashboards"}, responses={@ApiResponse(responseCode="404", description="No dashboard template with given ID not found."), @ApiResponse(responseCode="200", description="Returns a file containing the dashboard template within Teamscale Version Container.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TeamscaleVersionContainer.class))})})
    public Response exportDashboardTemplate(@Parameter(description="ID of the dashboard template") @PathParam(value="templateId") UUID templateId) throws NotFoundException, StorageException {
        DashboardTemplateIndex dashboardTemplateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        DashboardTemplateDescriptor descriptor = dashboardTemplateIndex.getDashboardTemplate(templateId);
        if (descriptor == null) {
            throw new NotFoundException("Dashboard template with ID " + String.valueOf(templateId) + " does not exist!");
        }
        descriptor.setId(null);
        return ResponseUtils.toFileDownload((Object)descriptor, (Enum)EDashboardTemplateDescriptorVersion.CURRENT_VERSION, (String)(descriptor.name + FILE_EXTENSION_TEMPLATE));
    }

    protected void updateElement(DashboardTemplateDescriptor oldElement, DashboardTemplateDescriptor newElement) throws StorageException {
        if (!Objects.equals(oldElement.getId(), newElement.getId())) {
            throw new BadRequestException("The ID must not be changed for a dashboard template.");
        }
        DashboardTemplateIndex dashboardTemplateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        newElement.setDescriptor(DashboardTemplateService.insertProjectPlaceholders(projectIndex, newElement.getDescriptor()));
        dashboardTemplateIndex.storeDashboardTemplate(newElement);
    }

    protected void createElement(DashboardTemplateDescriptor newElement) throws StorageException {
        DashboardTemplateIndex dashboardTemplateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        newElement.setDescriptor(DashboardTemplateService.insertProjectPlaceholders(projectIndex, newElement.getDescriptor()));
        dashboardTemplateIndex.storeDashboardTemplate(newElement);
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.DASHBOARD_TEMPLATES, newElement.getId().toString());
    }

    private void removeDashboardTemplate(UUID dashboardTemplateId) throws StorageException {
        DashboardTemplateIndex dashboardTemplateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        dashboardTemplateIndex.removeDashboardTemplate(dashboardTemplateId);
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(EBasicPermissionScope.DASHBOARD_TEMPLATES, dashboardTemplateId.toString());
    }

    static JsonNode insertProjectPlaceholders(ProjectIndex projectIndex, JsonNode originalDashboardDescription) throws StorageException {
        String newDashboardDescription = DashboardTemplateService.insertProjectNameAndIdPlaceholdersInWidgetTitles(projectIndex, JsonUtils.serializeToJSON((Object)originalDashboardDescription));
        newDashboardDescription = newDashboardDescription.replaceAll(JSON_PROJECT_PATTERN, "$1<PROJECT>$3");
        try {
            return JsonUtils.deserializeFromJson((String)newDashboardDescription.replaceAll(JSON_PATH_PATTERN, "$1<PATH>$3"));
        }
        catch (JsonSerializationException e) {
            CCSMAssert.fail((String)("Template replacements should preserve validity of JSON: " + e.getMessage()));
            return null;
        }
    }

    private static String insertProjectNameAndIdPlaceholdersInWidgetTitles(ProjectIndex projectIndex, String description) throws StorageException {
        StringBuilder descriptionBuilder = new StringBuilder(description);
        Matcher projectParameterMatcher = Pattern.compile(JSON_PROJECT_PATTERN).matcher(descriptionBuilder);
        HashSet<PublicProjectId> projectIds = new HashSet<PublicProjectId>();
        while (projectParameterMatcher.find()) {
            PublicProjectId projectId = new PublicProjectId(projectParameterMatcher.group(2));
            projectIds.add(projectId);
        }
        String result = description;
        Matcher titleMatcher = JSON_TITLE_PATTERN.matcher(result);
        while (titleMatcher.find()) {
            String originalTitle;
            String modifiedTitle = originalTitle = titleMatcher.group();
            for (PublicProjectId projectId : projectIds) {
                modifiedTitle = DashboardTemplateService.performPlaceholderReplacementInTitle(projectIndex, modifiedTitle, projectId);
            }
            if (originalTitle.equals(modifiedTitle)) continue;
            result = result.replace(originalTitle, modifiedTitle);
            titleMatcher = JSON_TITLE_PATTERN.matcher(result);
        }
        return result;
    }

    private static String performPlaceholderReplacementInTitle(ProjectIndex projectIndex, String title, PublicProjectId projectId) throws StorageException {
        String result = title.replaceAll(Pattern.quote(projectId.toString()), "<PROJECT>");
        Optional projectInfo = projectIndex.tryResolveProject((IProjectId)projectId);
        if (projectInfo.isPresent()) {
            String projectName = ((ProjectInfo)projectInfo.get()).getName();
            result = result.replaceAll(Pattern.quote(projectName), "<PROJECT_NAME>");
        }
        return result;
    }

    private UserResolvedDashboardTemplateDescriptor getDashboardTemplate(UUID dashboardTemplateId) throws StorageException {
        DashboardTemplateIndex dashboardTemplateIndex = this.openGlobalIndex(DashboardTemplateIndex.class);
        DashboardTemplateDescriptor template = dashboardTemplateIndex.getDashboardTemplate(dashboardTemplateId);
        if (template == null) {
            throw new NotFoundException("Dashboard template with ID " + String.valueOf(dashboardTemplateId) + " doesn't exist.");
        }
        return new UserResolvedDashboardTemplateDescriptor(template, UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()), this.openGlobalIndex(PermissionIndex.class), this.getPermissions());
    }
}

