/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard.widgets;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.user.User;
import com.teamscale.index.code_ownership.CodeOwnershipData;
import com.teamscale.index.code_ownership.CodeOwnershipIndex;
import com.teamscale.index.resource.VirtualCodePathUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.metrics.treemap.builder.NumericValueTreeMapBuilderBase;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class CodeOwnershipTreemapBuilder
extends NumericValueTreeMapBuilderBase<Integer, TreeMapNode> {
    private final UserAliasLookup userAliasLookup;
    private final long baselineTimestamp;
    private final ProjectStorageSystem projectStorageSystem;
    private final boolean excludeMergeCommits;
    private final boolean excludeImportCommits;

    protected CodeOwnershipTreemapBuilder(Pattern includePattern, Pattern excludePattern, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, Object colorMetricDefault, Color baseColor, ProjectStorageSystem projectStorageSystem, boolean excludeMergeCommits, boolean excludeImportCommits, UserAliasLookup userAliasLookup, long baselineTimestamp) {
        super(includePattern, excludePattern, metricRetrievalStrategy, historyAccessOption, areaMetricIndex, colorMetricDefault, baseColor, false);
        this.projectStorageSystem = projectStorageSystem;
        this.excludeMergeCommits = excludeMergeCommits;
        this.excludeImportCommits = excludeImportCommits;
        this.userAliasLookup = userAliasLookup;
        this.baselineTimestamp = baselineTimestamp;
    }

    private CodeOwnershipIndex getCodeOwnershipIndex() throws StorageException {
        return (CodeOwnershipIndex)this.projectStorageSystem.openProjectIndex(CodeOwnershipIndex.class, this.historyAccessOption);
    }

    @Override
    protected Map<String, Integer> calculateValues(String pathPrefix) throws StorageException {
        UniformPath uniformPathPrefix = UniformPathCompatibilityUtil.convert((String)pathPrefix);
        Map<UniformPath, CodeOwnershipData> ownershipEntries = this.getOwnershipEntries(uniformPathPrefix);
        ownershipEntries.forEach((uniformPath, ownershipData) -> ownershipData.removeAuthorsCommittedBefore(this.baselineTimestamp));
        HashMap<UniformPath, CodeOwnershipData> ownershipDataMap = new HashMap<UniformPath, CodeOwnershipData>();
        ownershipEntries.forEach((uniformPath, ownershipData) -> {
            ownershipData.removeAuthorsCommittedBefore(this.baselineTimestamp);
            UniformPath path = uniformPath;
            while (!path.isRoot() && path.hasAncestor(uniformPathPrefix)) {
                ownershipDataMap.merge(path, (CodeOwnershipData)ownershipData, CodeOwnershipData::merge);
                path = path.getParent();
            }
        });
        CounterSet result = new CounterSet();
        ownershipDataMap.forEach((uniformPath, ownershipData) -> result.inc((Object)uniformPath.toStringAsMigrationFrontier(), this.getUsernames((CodeOwnershipData)ownershipData, this.userAliasLookup).size()));
        return result.toMap();
    }

    private Map<UniformPath, CodeOwnershipData> getOwnershipEntries(UniformPath path) throws StorageException {
        if (path.isVirtualCodePath()) {
            return this.loadCodeOwnershipDataForVirtualPath(path);
        }
        return this.getCodeOwnershipIndex().getCodeOwnershipData(path.toStringAsMigrationFrontier()).stream().map(pair -> new Pair((Object)UniformPathCompatibilityUtil.convert((String)((String)pair.getFirst())), (Object)((CodeOwnershipData)pair.getSecond()))).filter(pair -> ((UniformPath)pair.getFirst()).hasAncestor(path)).collect(Collectors.toMap(ImmutablePair::getFirst, ImmutablePair::getSecond));
    }

    private Map<UniformPath, CodeOwnershipData> loadCodeOwnershipDataForVirtualPath(UniformPath path) throws StorageException {
        Set codePaths = VirtualCodePathUtils.resolveToCodePaths((UniformPath)path, (ProjectStorageSystem)this.projectStorageSystem, (HistoryAccessOption)this.historyAccessOption);
        VirtualCodePathUtils.IVirtualPathLookup virtualPathLookup = VirtualCodePathUtils.getVirtualPathLookup((UniformPath)path, (ProjectStorageSystem)this.projectStorageSystem, (HistoryAccessOption)this.historyAccessOption);
        HashMap<UniformPath, CodeOwnershipData> ownershipEntries = new HashMap<UniformPath, CodeOwnershipData>();
        CodeOwnershipIndex codeOwnershipIndex = this.getCodeOwnershipIndex();
        for (UniformPath codePath : codePaths) {
            PairList codeOwnershipData = codeOwnershipIndex.getCodeOwnershipData(codePath.toStringAsMigrationFrontier());
            for (Pair pair : codeOwnershipData) {
                UniformPath ownershipPath = UniformPathCompatibilityUtil.convert((String)((String)pair.getFirst()));
                virtualPathLookup.lookupVirtualPath(ownershipPath).ifPresent(virtualPath -> ownershipEntries.put((UniformPath)virtualPath, (CodeOwnershipData)pair.getSecond()));
            }
        }
        return ownershipEntries;
    }

    private Set<String> getUsernames(CodeOwnershipData ownershipData, UserAliasLookup userAliasLookup) {
        Set authors = this.excludeMergeCommits ? ownershipData.getCommitters() : ownershipData.getCommittersAndMergers();
        if (this.excludeImportCommits) {
            authors.remove("Teamscale import");
        }
        HashSet<String> resolvedUsers = new HashSet<String>();
        authors.forEach(author -> resolvedUsers.add(userAliasLookup.resolveUser(author).map(User::getUsername).orElse((String)author)));
        return resolvedUsers;
    }

    @Override
    protected String formatMetricValue(Object value) {
        double doubleValue = Double.parseDouble(value.toString());
        int intValue = (int)doubleValue;
        return String.valueOf(intValue);
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException {
        return new TreeMapNode(entry.getUniformPath(), entry.getDoubleValue(this.areaMetricIndex), this.formatMetricValue(entry.getValueOrDefault(this.builderParameters.colorMetricIndex, this.builderParameters.colorMetricDefault)), this.determineColor(entry));
    }
}

