/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.NumericThresholds;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.documentation.DocumentationBuilderException;
import com.teamscale.service.documentation.analysis_profile.AnalysisProfileDocumentationBuilderConfiguration;
import com.teamscale.service.documentation.analysis_profile.FindingDocumentation;
import com.teamscale.service.documentation.analysis_profile.GroupDocumentation;
import com.teamscale.service.documentation.analysis_profile.OptionDocumentation;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.ICheckOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSequencedMap;
import org.conqat.lib.commons.string.StringUtils;

public abstract class GroupDocumentationBuilderBase {
    private final AnalysisProfileDocumentationBuilderConfiguration configuration;
    private static final Pattern HEADING_PATTERN = Pattern.compile("^(#+)", 8);

    public GroupDocumentationBuilderBase(AnalysisProfileDocumentationBuilderConfiguration configuration) {
        this.configuration = configuration;
    }

    public GroupDocumentation buildAnalysisGroupDocumentation(AnalysisGroup group) throws DocumentationBuilderException {
        List<FindingDocumentation> findingDocumentations = this.buildFindingDocs(group);
        if (CollectionUtils.isNullOrEmpty(findingDocumentations)) {
            return null;
        }
        return this.createGroupDocumentation(group, findingDocumentations);
    }

    protected abstract GroupDocumentation createGroupDocumentation(AnalysisGroup var1, List<FindingDocumentation> var2);

    protected abstract FindingDocumentation createFindingDoc(String var1, String var2, EAnalysisTool var3, EFindingEnablement var4, List<OptionDocumentation> var5);

    private List<FindingDocumentation> buildFindingDocs(AnalysisGroup group) throws DocumentationBuilderException {
        ArrayList<FindingDocumentation> findingDocumentations = new ArrayList<FindingDocumentation>();
        List findingDescriptors = AnalysisProfileUtils.getFindingsDescriptors((AnalysisGroup)group, (ConfigurationTemplate)this.configuration.getTemplate());
        for (FindingDescriptor findingDescriptor : findingDescriptors) {
            EFindingEnablement enablement;
            String checkId = findingDescriptor.getName();
            String enablementOption = group.getOptionValue(checkId);
            if (enablementOption == null || !(enablement = EFindingEnablement.valueOf((String)enablementOption.toUpperCase())).isEnabled()) continue;
            List<OptionDocumentation> optionDocumentations = findingDescriptors.size() == 1 ? this.buildOptionDocs(group) : this.buildOptionDocs(checkId, group);
            String description = findingDescriptor.getDescription();
            String adjustedDescription = GroupDocumentationBuilderBase.updateMarkdownElements(description);
            findingDocumentations.add(this.createFindingDoc(findingDescriptor.getReadableName(), adjustedDescription, findingDescriptor.getTool(), enablement, optionDocumentations));
        }
        return findingDocumentations;
    }

    private static String updateMarkdownElements(String description) {
        Matcher matcher = HEADING_PATTERN.matcher(description);
        return matcher.replaceAll(match -> {
            int currentLevel = match.group(1).length();
            if (currentLevel == 1) {
                return "#####";
            }
            if (currentLevel == 2) {
                return "#####";
            }
            return "######";
        });
    }

    private List<OptionDocumentation> buildOptionDocs(AnalysisGroup group) throws DocumentationBuilderException {
        ArrayList<OptionDocumentation> optionDocumentations = new ArrayList<OptionDocumentation>();
        AnalysisGroupDescriptor groupDescriptor = this.configuration.getTemplate().getAnalysisGroup(group.getName());
        List options = CollectionUtils.filterAndMap((Collection)groupDescriptor.getConfigurationItems(), ConfigOptionDescriptorBase.class::isInstance, ConfigOptionDescriptorBase.class::cast);
        for (ConfigOptionDescriptorBase option : options) {
            String optionName;
            Object optionValue;
            if (option.getVisibility() != ConfigExposed.EConfigVisibility.DEFAULT || StringUtils.isEmpty((String)(optionValue = group.getOptionValue(optionName = option.getName())))) continue;
            try {
                option.setValueAndDefaultValue((String)optionValue, CodeScopeAware.DEFAULT_CODE_SCOPE);
            }
            catch (ProjectConfigurationException e) {
                throw new DocumentationBuilderException("Could not parse option for " + optionName, e);
            }
            Object retrievedValue = option.retrieveValue(CodeScopeAware.DEFAULT_CODE_SCOPE);
            if (retrievedValue instanceof NumericThresholds) {
                NumericThresholds numericThresholds = (NumericThresholds)retrievedValue;
                optionValue = "Yellow Threshold: " + numericThresholds.getYellowThreshold() + ", Red Threshold: " + numericThresholds.getRedThreshold();
            }
            OptionDocumentation optionDocumentation = new OptionDocumentation(optionName, option.getDescription(), null, (String)optionValue);
            optionDocumentations.add(optionDocumentation);
        }
        return optionDocumentations;
    }

    private List<OptionDocumentation> buildOptionDocs(String checkId, AnalysisGroup group) {
        ArrayList<OptionDocumentation> optionDocumentations = new ArrayList<OptionDocumentation>();
        CheckInfo checkInfo = this.configuration.getCheckInfoMap().get(checkId);
        if (checkInfo != null) {
            UnmodifiableSequencedMap options = checkInfo.getOptions();
            for (Map.Entry optionEntry : options.entrySet()) {
                String optionName = (String)optionEntry.getKey();
                String optionValue = group.getOptionValue(optionName);
                if (StringUtils.isEmpty((String)optionValue)) continue;
                OptionDocumentation optionDocumentation = new OptionDocumentation(optionName, ((ICheckOption)optionEntry.getValue()).getDescription(), checkId, optionValue);
                optionDocumentations.add(optionDocumentation);
            }
        }
        return optionDocumentations;
    }
}

