/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.tools.CustomExternalMetricsConfiguration;
import com.teamscale.index.project.ExternalCodeMetricsDescriptionIndex;
import com.teamscale.index.project.ExternalMetricsDescriptionIndexBase;
import com.teamscale.index.project.ExternalNonCodeMetricsDescriptionIndex;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.ExternalMetricsServiceUtils;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/external-metrics")
public class ExternalMetricDescriptionService
extends ApiBase {
    public static final String TYPE_PARAMETER = "type";
    private static final String TYPE_PARAMETER_DESCRIPTION = "The type of external metric (CODE or NON_CODE)";
    private static final String TYPE_PARAMETER_DEFAULT = "CODE";

    @GET
    @Operation(summary="Get metrics", description="Retrieves the available external metrics.", tags={"External Metrics"})
    @RequiresNoPermission
    public List<MetricSchemaChangeEntry> getMetricSchemaEntries(@Parameter(description="The type of external metric (CODE or NON_CODE)") @QueryParam(value="type") @DefaultValue(value="CODE") UniformPath.EType uniformPathType) throws StorageException {
        return this.openExternalMetricsDescriptionIndex(uniformPathType).getAllMetrics();
    }

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_8_0)
    @Operation(summary="Add metrics", description="Adds a set of external metrics to the schema.", tags={"External Metrics"}, responses={@ApiResponse(responseCode="400", description="Invalid external metric entry provided."), @ApiResponse(responseCode="400", description="Invalid external metric description.")})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_METRICS_SCHEMA})
    public void addExternalMetrics(@Parameter(description="The type of external metric (CODE or NON_CODE)") @QueryParam(value="type") @DefaultValue(value="CODE") UniformPath.EType uniformPathType, @RequestBody(required=true) List<MetricSchemaChangeEntry> metrics) throws StorageException {
        ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex = this.openExternalMetricsDescriptionIndex(uniformPathType);
        this.validateAndStoreMetrics(metrics, externalMetricsDescriptionIndex);
    }

    @PUT
    @Operation(summary="Update metrics", description="Updates a set of external metrics", tags={"External Metrics"}, responses={@ApiResponse(responseCode="400", description="Invalid external metric entry provided."), @ApiResponse(responseCode="404", description="The metric entry with given ID could not be found.")})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_METRICS_SCHEMA})
    public void updateExternalMetrics(@Parameter(description="The type of external metric (CODE or NON_CODE)") @QueryParam(value="type") @DefaultValue(value="CODE") UniformPath.EType uniformPathType, @RequestBody(required=true) List<MetricSchemaChangeEntry> metrics) throws StorageException {
        ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex = this.openExternalMetricsDescriptionIndex(uniformPathType);
        this.validateMetrics(metrics, externalMetricsDescriptionIndex);
        ExternalMetricDescriptionService.updateMetricEntries(metrics, externalMetricsDescriptionIndex);
    }

    @DELETE
    @Path(value="{metricName}")
    @Operation(summary="Delete metric", description="Deletes an external metric.", tags={"External Metrics"}, responses={@ApiResponse(responseCode="400", description="Empty content provided."), @ApiResponse(responseCode="400", description="Provided external metric is still used in analysis profile(s).")})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_EXTERNAL_METRICS_SCHEMA})
    public void deleteExternalMetric(@Parameter(description="The type of external metric (CODE or NON_CODE)") @QueryParam(value="type") @DefaultValue(value="CODE") UniformPath.EType uniformPathType, @Parameter(description="Metric to delete") @PathParam(value="metricName") String unsanitizedMetricName) throws StorageException {
        String metricName = StringUtils.stripPrefix((String)unsanitizedMetricName, (String)"/");
        if (StringUtils.isEmpty((String)metricName)) {
            throw new BadRequestException("Empty content provided.");
        }
        ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex = this.openExternalMetricsDescriptionIndex(uniformPathType);
        MetricSchemaChangeEntry metricToBeDeleted = externalMetricsDescriptionIndex.getMetric(metricName);
        if (metricToBeDeleted != null) {
            this.checkMetricInUse(metricName, metricToBeDeleted);
            externalMetricsDescriptionIndex.removeMetric(metricName);
        }
    }

    private ExternalMetricsDescriptionIndexBase openExternalMetricsDescriptionIndex(UniformPath.EType uniformPathType) throws StorageException {
        return switch (uniformPathType) {
            case UniformPath.EType.CODE -> this.openGlobalIndex(ExternalCodeMetricsDescriptionIndex.class);
            case UniformPath.EType.NON_CODE -> this.openGlobalIndex(ExternalNonCodeMetricsDescriptionIndex.class);
            default -> throw new BadRequestException("Unsupported uniform path type: " + String.valueOf(uniformPathType));
        };
    }

    private void checkMetricInUse(String metricName, MetricSchemaChangeEntry metricToBeDeleted) throws StorageException, BadRequestException {
        AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
        List allProfiles = analysisProfileIndex.getAllProfiles();
        List<AnalysisProfile> profilesUsingMetric = allProfiles.stream().filter(profile -> ExternalMetricDescriptionService.profileUsesCustomMetric(metricToBeDeleted, profile)).toList();
        if (!profilesUsingMetric.isEmpty()) {
            throw new BadRequestException("External metric \"" + metricName + "\" is still used in analysis profile(s): " + profilesUsingMetric.stream().map(NamedConfigurableObjectBase::getName).collect(Collectors.joining(", ")));
        }
    }

    private void validateAndStoreMetrics(List<MetricSchemaChangeEntry> schemaEntries, ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex) throws BadRequestException, StorageException {
        this.validateMetrics(schemaEntries, externalMetricsDescriptionIndex);
        externalMetricsDescriptionIndex.putMetrics(schemaEntries);
    }

    private void validateMetrics(List<MetricSchemaChangeEntry> schemaEntries, ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex) throws StorageException {
        ExternalMetricsServiceUtils.validateIdentifiersInMetricSchemaEntries(schemaEntries);
        ExternalMetricsServiceUtils.warnIfMetricSchemaEntryIdAlreadyInUse(schemaEntries, this.getGlobalStorageSystem());
        CustomExternalMetricsConfiguration.validateCustomExternalMetrics(schemaEntries, (ExternalMetricsDescriptionIndexBase)externalMetricsDescriptionIndex);
    }

    private static void updateMetricEntries(List<MetricSchemaChangeEntry> schemaEntries, ExternalMetricsDescriptionIndexBase externalMetricsDescriptionIndex) throws BadRequestException, StorageException {
        List customExternalMetrics = externalMetricsDescriptionIndex.getAllMetrics();
        for (MetricSchemaChangeEntry changeEntry : schemaEntries) {
            List existingMetric = CollectionUtils.filter((Collection)customExternalMetrics, metric -> metric.getMetricId().equals(changeEntry.getMetricId()));
            if (!existingMetric.isEmpty()) continue;
            throw new NotFoundException("The metric with ID " + changeEntry.getMetricId() + " does not exist!");
        }
        externalMetricsDescriptionIndex.putMetrics(schemaEntries);
    }

    private static boolean profileUsesCustomMetric(MetricSchemaChangeEntry metricEntry, AnalysisProfile profile) {
        String metricGroupName = metricEntry.getAnalysisGroup();
        String metricUiName = metricEntry.getMetricDirectoryEntry().getName();
        if (!profile.getTools().contains((Object)EAnalysisTool.CUSTOM_METRICS)) {
            return false;
        }
        List analysisGroupsWithMetricGroupName = profile.getQualityIndicators().stream().flatMap(indicator -> indicator.getGroups().stream()).filter(group -> group.getName().equals(metricGroupName)).collect(Collectors.toList());
        return analysisGroupsWithMetricGroupName.stream().anyMatch(group -> group.getOptionNames().contains((Object)metricUiName));
    }
}

