/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.core.user.User;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/findings/review-findings")
public class ReviewFindingImportService
extends SessionBasedExternalAnalysisServiceBase<SessionBasedExternalAnalysisServiceQueryOptions> {
    @POST
    @Operation(summary="Create review finding", description="Creates a code review finding.", tags={"Findings"}, responses={@ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public void createReviewFinding(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @RequestBody(required=true) List<ReviewComment> reviewComments) throws StorageException {
        SessionBasedExternalAnalysisServiceQueryOptions parameters = new SessionBasedExternalAnalysisServiceQueryOptions();
        parameters.setCommit(commit);
        parameters.setUploadMessage("Code Review by " + this.serviceInfo.getUser().getFullName());
        parameters.setPartition("code-review-findings");
        ArrayList<IExternalUploadRequestPart> requestParts = new ArrayList<IExternalUploadRequestPart>(reviewComments);
        this.process(EHttpMethod.POST, requestParts, parameters, "auto-create");
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionManager sessionManager, List<IExternalUploadRequestPart> externalData, SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        ExternalAnalysisImportInfos infos = new ExternalAnalysisImportInfos();
        ArrayList<ReviewComment> reviewComments = new ArrayList<ReviewComment>();
        for (IExternalUploadRequestPart datum : externalData) {
            reviewComments.add((ReviewComment)datum);
        }
        ListMap reviewFindingsByPath = new ListMap();
        for (ReviewComment reviewComment : reviewComments) {
            DetachedFinding reviewFinding = ReviewFindingImportService.createReviewFinding(reviewComment, this.getUser());
            reviewFindingsByPath.add((Object)reviewComment.uniformPath, (Object)reviewFinding);
        }
        for (UniformPath uniformPath : reviewFindingsByPath.getKeys()) {
            ArrayList findings = new ArrayList(reviewFindingsByPath.getCollectionOrEmpty((Object)uniformPath));
            infos.addInfo((ExternalAnalysisImportInfo)new ExternalAnalysisImportInfoFindings(uniformPath.toStringAsMigrationFrontier(), findings));
        }
        sessionManager.storeNewImportInfosForSession(session, infos);
    }

    private static DetachedFinding createReviewFinding(ReviewComment reviewComment, User reviewer) {
        return ReviewFindingImportService.createReviewFinding(reviewComment.message, (ElementLocation)new TextRegionLocation(reviewComment.uniformPath.toStringAsMigrationFrontier(), -1, -1, reviewComment.startLine, reviewComment.endLine), reviewer);
    }

    public static DetachedFinding createReviewFinding(String message, ElementLocation location, User reviewer) {
        DetachedFinding reviewFinding = new DetachedFinding("Review Comment", "Code Review", message, location);
        reviewFinding.setProperty("Reviewer", (Object)reviewer.getFullName());
        return reviewFinding;
    }

    public record ReviewComment(UniformPath uniformPath, String message, int startLine, int endLine) implements IExternalUploadRequestPart
    {
        public ReviewComment(UniformPath uniformPath, String message, int startLine, int endLine) {
            this.uniformPath = uniformPath = uniformPath.resolveToCodePath();
            this.message = message;
            this.startLine = startLine;
            this.endLine = endLine;
        }
    }
}

