/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.status;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.external.ExternalAnalysisDeletionIndex;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisCommitStatus;
import com.teamscale.index.external.status.ExternalAnalysisPartitionInfo;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisShortStatusInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.index.resource.ExternalAnalysisReportArchiveIndex;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/external-analysis/status")
public class ExternalAnalysisStatusService
extends ApiBase {
    private Set<CommitDescriptor> commitsMarkedForDeletion;

    @GET
    @Path(value="partitions")
    @Operation(summary="Get partitions", description="Returns the list of external upload partitions in this project.", tags={"External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<ExternalAnalysisPartitionInfo> getExternalAnalysisStatusPartitions() throws StorageException {
        return (List)this.openProjectIndex(ExternalAnalysisStatusIndex.class, null).computeWithLock(ExternalAnalysisStatusIndex.LockedIndexAccess::getPartitionInfos);
    }

    @GET
    @Path(value="partitions/{partition}")
    @Operation(summary="Get uploads", description="Returns the uploads for a given partition.", tags={"External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS, EProjectPermission.VIEW})
    public List<ExternalAnalysisCommitStatus> getExternalAnalysisStatusUploads(@PathParam(value="partition") String partition) throws StorageException {
        ExternalAnalysisStatusIndex statusIndex = this.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        ArrayList result = new ArrayList();
        PairList commitsForPartition = (PairList)statusIndex.computeWithLock(lockedIndex -> lockedIndex.getCommitsForPartition(partition));
        this.collectDeletionInfos((List<CommitDescriptor>)commitsForPartition.getFirstList());
        commitsForPartition.forEach((commit, status) -> result.add(this.getCommitStatusWithDeletion((CommitDescriptor)commit, (ExternalAnalysisShortStatusInfo)status)));
        return CollectionUtils.reverse(result);
    }

    private void collectDeletionInfos(List<CommitDescriptor> commits) throws StorageException {
        ExternalAnalysisDeletionIndex deletionIndex = this.openProjectIndex(ExternalAnalysisDeletionIndex.class, null);
        this.commitsMarkedForDeletion = deletionIndex.findCommitsMarkedForDeletion(commits);
    }

    private ExternalAnalysisCommitStatus getCommitStatusWithDeletion(CommitDescriptor commit, ExternalAnalysisShortStatusInfo status) {
        if (this.commitsMarkedForDeletion.contains(commit)) {
            return new ExternalAnalysisCommitStatus(commit, status.hasErrors(), status.getMessage(), EExternalAnalysisProcessingStatus.DELETING, status.isUpload(), status.getUploadTimestamp(), status.isStoredExternally());
        }
        return new ExternalAnalysisCommitStatus(commit, status);
    }

    @GET
    @Path(value="commits/{commit}")
    @Operation(summary="Get upload commit details", description="Returns the details for a given upload commit.", tags={"External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public ExternalAnalysisStatusInfo getUploadCommitDetails(@PathParam(value="commit") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        CommitDescriptor commit = this.resolve(unresolvedCommit);
        ExternalAnalysisStatusInfo status = (ExternalAnalysisStatusInfo)this.openProjectIndex(ExternalAnalysisStatusIndex.class, null).computeWithLock(lockedIndex -> lockedIndex.getStatus(commit));
        if (status == null) {
            throw new NotFoundException();
        }
        ExternalAnalysisReportArchiveIndex reportArchiveIndex = this.openProjectIndex(ExternalAnalysisReportArchiveIndex.class, null);
        List reportArchiveInfos = reportArchiveIndex.getReportArchiveInfos(commit);
        if (reportArchiveInfos != null) {
            status.addReportArchiveInfos(reportArchiveInfos);
        }
        this.addDeletionStepIfExists(status);
        return status;
    }

    @GET
    @Path(value="commit-infos")
    @Operation(summary="Get all external analysis upload commits for the specified timeframe and partitions", description="Returns status infos for all external analysis upload commits in the given partitions which occurred in the given timeframe. The relevant commits are collected by going back from the given end commit through all of its predecessors until the given baseline timestamp is reached.", tags={"Tests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public ListMap<String, ExternalAnalysisCommitStatus> getExternalAnalysisCommitInfos(@QueryParam(value="baseline") @Parameter(description="Baseline commit. We only use this for the timestamp. Only upload commits after this timestamp will be considered.") UnresolvedCommitDescriptor startCommit, @QueryParam(value="end") @Parameter(description="End commit. Only upload commits which are reachable via predecessors of this commit will be considered") UnresolvedCommitDescriptor endCommit, @QueryParam(value="partitions") @Parameter(description="This parameter may be given multiple times. Specifies the test coverage partitions to consider.") List<String> partitions, @QueryParam(value="all-partitions") @Parameter(description="If this is true, all available test coverage partitions are considered.") boolean allPartitions) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = this.openProjectIndex(CommitDescriptorIndex.class, null);
        CommitDescriptor resolvedEndCommit = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)endCommit, () -> this.getProjectStorageSystem());
        long resolvedStartTimestamp = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)startCommit, () -> this.getProjectStorageSystem()).getTimestamp();
        if (resolvedStartTimestamp == resolvedEndCommit.getTimestamp()) {
            if (resolvedEndCommit.isHeadCommit()) {
                Optional firstActualCommitBeforeOrAtEnd = commitDescriptorIndex.getFirstActualCommitBeforeOrAt(resolvedEndCommit, 1L);
                if (firstActualCommitBeforeOrAtEnd.isPresent()) {
                    resolvedStartTimestamp = ((CommitDescriptor)firstActualCommitBeforeOrAtEnd.get()).getTimestamp() - 1L;
                }
            } else {
                --resolvedStartTimestamp;
            }
        }
        List commitHistory = commitDescriptorIndex.getCommitHistory(resolvedEndCommit, resolvedStartTimestamp);
        List<String> resolvedPartitions = this.getResolvedPartitions(partitions, allPartitions, resolvedEndCommit);
        return (ListMap)this.openProjectIndex(ExternalAnalysisStatusIndex.class, null).computeWithLock(lockedIndex -> lockedIndex.getExternalAnalysisUploadsPerPartition(resolvedPartitions, commitHistory));
    }

    private List<String> getResolvedPartitions(List<String> partitions, boolean allPartitions, CommitDescriptor resolvedEndCommit) throws StorageException {
        if (!allPartitions) {
            return partitions;
        }
        MethodLastTestedIndex methodLastTestedIndex = this.openProjectIndex(MethodLastTestedIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)resolvedEndCommit));
        return methodLastTestedIndex.getPartitions();
    }

    private void addDeletionStepIfExists(ExternalAnalysisStatusInfo statusInfo) throws StorageException {
        ExternalAnalysisDeletionIndex deletionIndex = this.openProjectIndex(ExternalAnalysisDeletionIndex.class, null);
        boolean isCommitMarkedForDeletion = deletionIndex.isCommitMarkedForDeletion(statusInfo.getCommit());
        if (isCommitMarkedForDeletion) {
            statusInfo.addProcessingStep(new ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus.DELETING, false, deletionIndex.getDeletionTimeForCommit(statusInfo.getCommit()), false));
        }
    }
}

