/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.findings.calculation.FindingsPaginationOptions;
import com.teamscale.service.dto.PreviousNextSiblings;
import com.teamscale.service.findings.ElementFindingsServiceBase;
import com.teamscale.service.findings.options.FindingSortOptions;
import com.teamscale.service.findings.options.FindingsRequestOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/findings/previousNextSiblings/{finding}")
public class FindingSiblingsService
extends ElementFindingsServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get finding siblings", description="Gets next and prev finding respecting filter and sort options. ", tags={"Findings"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    public PreviousNextSiblings getFindingsSiblings(@BeanParam FindingsRequestOptions requestOptions, @PathParam(value="finding") String id) throws StorageException {
        List<String> ids = this.retrieveFilteredAndSortedFindingIds(requestOptions.getUniformPath(), requestOptions.getFindingsFilterSettings(), requestOptions.getSortOptions());
        int index = ids.indexOf(id);
        return new PreviousNextSiblings(FindingSiblingsService.get(ids, index - 1), FindingSiblingsService.get(ids, index + 1), index, ids.size());
    }

    private static String get(List<String> list, int index) {
        try {
            return list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private List<String> retrieveFilteredAndSortedFindingIds(UniformPath uniformPath, FindingsFilterSettings findingsFilterSettings, FindingSortOptions sortOptions) throws StorageException {
        List findings = this.retrieveFilteredFindingsWithSortingAndPagination(uniformPath, false, findingsFilterSettings, sortOptions, FindingsPaginationOptions.all()).findings();
        return CollectionUtils.map((Collection)findings, TrackedFinding::getId);
    }
}

