/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsDescriptionOverrideCache;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.IFindingTypeDescriptorService;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/finding-type-descriptors")
public class FindingTypeDescriptorService
extends ApiBase
implements IFindingTypeDescriptorService {
    @Override
    public List<FindingTypeDescription> getFindingTypeDescriptions(@RequestBody(required=true) List<String> findingTypeIds) throws StorageException {
        FindingsSchemaIndex findingsSchemaIndex = this.getFindingsSchemaIndex();
        SynchronizedCacheAccess<FindingsDescriptionOverrideCache> cacheAccess = this.getCacheAccess();
        ArrayList<FindingTypeDescription> result = new ArrayList<FindingTypeDescription>();
        SequencedSet codeScopeNames = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)this.getProjectStorageSystem()).getCodeScopeNames();
        CodeScopeAware codeScopes = CodeScopeAware.fromMap(codeScopeNames.stream().collect(Collectors.toMap(Function.identity(), ignored -> findingTypeIds)));
        CodeScopeAware values = findingsSchemaIndex.getFindingTypeDescriptions(codeScopes);
        for (String findingTypeId : findingTypeIds) {
            FindingTypeDescription findingTypeDescription = codeScopeNames.reversed().stream().map(arg_0 -> ((CodeScopeAware)values).getValue(arg_0)).map(v -> (FindingTypeDescription)v.get(findingTypeId)).filter(Objects::nonNull).findFirst().orElse(null);
            result.add(FindingTypeDescriptorService.getFindingTypeDescriptionNullSafe(findingTypeId, findingTypeDescription, cacheAccess));
        }
        return result;
    }

    private FindingsSchemaIndex getFindingsSchemaIndex() throws StorageException {
        return this.openProjectIndex(FindingsSchemaIndex.class, null);
    }

    private SynchronizedCacheAccess<FindingsDescriptionOverrideCache> getCacheAccess() {
        return this.getIndexLayer().getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(FindingsDescriptionOverrideCache.class);
    }

    @Override
    public Map<CodeScopeName, Map<String, FindingTypeDescription>> getFindingTypeDescriptions(Map<CodeScopeName, Set<String>> findingTypeIds) throws StorageException {
        HashMap<CodeScopeName, Map<String, FindingTypeDescription>> result = new HashMap<CodeScopeName, Map<String, FindingTypeDescription>>();
        FindingsSchemaIndex findingsSchemaIndex = this.getFindingsSchemaIndex();
        CodeScopeAware findingTypeDescriptions = findingsSchemaIndex.getFindingTypeDescriptions(CodeScopeAware.fromMap(findingTypeIds));
        SynchronizedCacheAccess<FindingsDescriptionOverrideCache> cacheAccess = this.getCacheAccess();
        for (Map.Entry<CodeScopeName, Set<String>> entry : findingTypeIds.entrySet()) {
            CodeScopeName codeScopeName = entry.getKey();
            Set<String> findingTypeIdSet = entry.getValue();
            HashMap<String, FindingTypeDescription> codeScopeResult = new HashMap<String, FindingTypeDescription>();
            for (String findingTypeId : findingTypeIdSet) {
                FindingTypeDescription findingTypeDescription = (FindingTypeDescription)((Map)findingTypeDescriptions.getValue(codeScopeName)).get(findingTypeId);
                codeScopeResult.put(findingTypeId, FindingTypeDescriptorService.getFindingTypeDescriptionNullSafe(findingTypeId, findingTypeDescription, cacheAccess));
            }
            result.put(codeScopeName, codeScopeResult);
        }
        return result;
    }

    public static FindingTypeDescription getFindingTypeDescriptionNullSafe(String typeId, FindingTypeDescription findingTypeDescription, SynchronizedCacheAccess<FindingsDescriptionOverrideCache> cacheAccess) throws StorageException {
        if (findingTypeDescription == null) {
            return new FindingTypeDescription(typeId, "", null);
        }
        return (FindingTypeDescription)cacheAccess.getOrUpdate(cache -> cache.adjustDescription(findingTypeDescription));
    }
}

