/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.refactoring;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.StructuringConfiguration;
import com.teamscale.index.dataflow.CFGConstructor;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.refactoring.ExtractMethodCandidate;
import com.teamscale.service.findings.refactoring.ExtractMethodCandidatesDeterminer;
import com.teamscale.service.findings.refactoring.Method;
import com.teamscale.service.findings.refactoring.RefactoringSuggestion;
import com.teamscale.service.findings.refactoring.RefactoringSuggestions;
import com.teamscale.service.findings.refactoring.TrackedFindingUtils;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Path(value="api/projects/{project}/findings/{findingId}/extract-method-suggestions")
public class ExtractMethodSuggestionsService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get refactoring suggestions", description="Returns extract method refactoring suggestions for a given finding as a sorted list (best-first) of refactoring suggestions for the method with the given finding.", responses={@ApiResponse(responseCode="204", description="No suggestions could be determined.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public RefactoringSuggestions getRefactoringSuggestions(@Parameter(description="The finding for which to suggest possible refactorings") @PathParam(value="findingId") String findingId, @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TrackedFindingsByIdIndex findingsIndex = this.openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption);
        TrackedFinding finding = findingsIndex.getFinding(findingId);
        if (finding == null) {
            throw new NotFoundException("No finding with id '" + findingId + "' found");
        }
        try {
            Method method = this.obtainMethod(historyAccessOption, finding);
            return ExtractMethodSuggestionsService.determineExtractMethodSuggestions(method, finding);
        }
        catch (ConQATException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static RefactoringSuggestions determineExtractMethodSuggestions(Method method, TrackedFinding finding) {
        ExtractMethodCandidatesDeterminer determiner = new ExtractMethodCandidatesDeterminer(method, ExtractMethodSuggestionsService.determineLineNumberForNestingDepthFindings(finding));
        List<ExtractMethodCandidate> candidates = determiner.getRefactoringCandidates();
        int appropriateNumberOfCandidates = (int)((double)method.getLength() * 0.1);
        int upperBoundForNumberOfCandidates = Math.max(appropriateNumberOfCandidates, 3);
        int numberOfCandidates = Math.min(upperBoundForNumberOfCandidates, candidates.size());
        ArrayList<RefactoringSuggestion> suggestions = new ArrayList<RefactoringSuggestion>();
        for (int i = 0; i < numberOfCandidates; ++i) {
            ExtractMethodCandidate candidate = candidates.get(i);
            suggestions.add(new RefactoringSuggestion(candidate));
        }
        int methodStartLine = method.getEntity().getStartLine();
        int methodEndLine = method.getEntity().getEndLine();
        return new RefactoringSuggestions(suggestions, methodStartLine, methodEndLine);
    }

    private static int determineLineNumberForNestingDepthFindings(TrackedFinding finding) {
        if (finding.getTypeId().equals(StructuringConfiguration.NESTING_DEPTH_TYPE_ID)) {
            return TrackedFindingUtils.getStartLine(finding);
        }
        return -1;
    }

    private Method obtainMethod(HistoryAccessOption historyAccessOption, TrackedFinding finding) throws ConQATException {
        String uniformPath = finding.getLocation().getUniformPath();
        TokenElementIndex tokenElementIndex = ResourceServiceUtils.openContentIndex((String)uniformPath, (HistoryAccessOption)historyAccessOption, (ProjectStorageSystem)this.getProjectStorageSystem());
        TokenElementInfo tokenElement = tokenElementIndex.getTokenElement(uniformPath);
        CCSMAssert.isNotNull((Object)tokenElement, (String)("Expected token element to exist: " + uniformPath));
        List shallowEntities = tokenElement.getRawShallowEntities();
        int findingStartLine = TrackedFindingUtils.getStartLine(finding);
        int findingEndLine = TrackedFindingUtils.getEndLine(finding);
        List classEntities = ShallowParsingUtils.getClassEntities((List)shallowEntities, (int)findingStartLine, (int)findingEndLine);
        List globalVariables = ShallowParsingUtils.getClassAttributes((List)classEntities);
        List<ControlFlowGraph> graphs = ExtractMethodSuggestionsService.getControlFlowGraphs(tokenElement, shallowEntities);
        Collections.reverse(graphs);
        ControlFlowGraph methodCfg = TrackedFindingUtils.getControlFlowGraphOfMethodFromFinding(graphs, finding);
        ShallowEntity methodEntity = (ShallowEntity)ShallowEntityTraversalUtils.listEntitiesOfType((Collection)methodCfg.getEntities(), (EShallowEntityType)EShallowEntityType.METHOD).get(0);
        return new Method(methodEntity, globalVariables, methodCfg);
    }

    private static List<ControlFlowGraph> getControlFlowGraphs(TokenElementInfo tokenElement, List<ShallowEntity> shallowEntities) throws ConQATException {
        List graphs = CFGConstructor.getControlFlowGraphs((ELanguage)tokenElement.getLanguage(), (String)tokenElement.getUniformPath(), shallowEntities, (boolean)false);
        if (graphs.isEmpty()) {
            throw new ConQATException("Could not obtain any control flow graphs from tokenElement " + tokenElement.toString() + " and shallowEntities " + shallowEntities.toString());
        }
        return graphs;
    }
}

