/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.testimpact.TestSuggestions;
import com.teamscale.service.testimpact.TgaBasedTestSuggestionsServiceBase;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/issues/{issueId}/test-suggestions")
public class IssueTestSuggestionsService
extends TgaBasedTestSuggestionsServiceBase {
    @GET
    @Operation(summary="Get test suggestions by issue", description="Retrieves the test suggestions for a given issue. This are all tests that are expected to execute the methods that have been changed in the context of the given ticket.", responses={@ApiResponse(responseCode="404", description="The issue identified by given ID could not be found.")}, tags={"Issues", "Test Intelligence"})
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    public TestSuggestions getIssueTestSuggestions(@Parameter(description="ID of the issue to retrieve impacted tests for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\".", schema=@Schema(type="string")) @PathParam(value="issueId") TeamscaleIssueId issueId, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam TiaPartitionsQueryParams partitionsQueryParams, @QueryParam(value="include-executed-tests") boolean includeExecuted) throws StorageException, InterruptedException, RepositoryException, BranchPointNotFoundException {
        return this.getTestSuggestions(partitionsQueryParams, issueTgaParameters, new TimeIntervalBasedServiceQueryOptions(), new TgaRequestQueryOptions(false, issueId.toString(), false, null, null), includeExecuted);
    }
}

