/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues.jira.debug;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/jira/debug/accessible-projects/{credentialsName}")
public class DebugListJiraProjectsService
extends ApiBase {
    @GET
    @Operation(summary="Returns a list of all Jira project names that can be accessed by Teamscale's Jira user", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getAllJiraProjects(@Parameter(description="The name of the external credential entry (set in Web UI upon creation)") @PathParam(value="credentialsName") String credentialsName) throws StorageException, BugTrackerException, ServiceCallException, ConnectorValidationException {
        if (StringUtils.isEmpty((String)credentialsName)) {
            throw new BadRequestException("Please specify the account name");
        }
        ExternalCredentialsIndex credentialsIndex = (ExternalCredentialsIndex)this.getGlobalStorageSystem().openGlobalIndex(ExternalCredentialsIndex.class);
        ExternalCredentials credentials = credentialsIndex.getExternalCredentials(credentialsName);
        if (credentials == null) {
            throw new BadRequestException("No credentials found for name " + credentialsName);
        }
        JiraClient jiraClient = new JiraClient(credentials.uri, credentials.username, credentials.password, Collections.emptyList());
        Map projects = jiraClient.toInstanceAwareClient(jiraClient.getInstanceType()).getProjectNamesByKey();
        List projectRepresentations = CollectionUtils.map(projects.entrySet(), entry -> (String)entry.getKey() + "(" + (String)entry.getValue() + ")");
        return "Jira projects accessible by Teamscale's Jira user for account '" + credentialsName + "':\n" + StringUtils.concat((Iterable)projectRepresentations, (String)",");
    }
}

