/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.service.DetailedServiceLog;
import com.teamscale.core.log.service.ShortCriticalEventServiceLog;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.core.log.worker.ShortCriticalEventWorkerLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IProjectLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/logs/critical-events")
public class CriticalEventsProjectLogService
extends ApiBase
implements IProjectLogServiceApi<ShortLogEntryBase, DetailedServiceLog> {
    @Override
    @Operation(summary="Get all critical event logs", description="Returns a list of all critical event short logs.", tags={"Logging"}, operationId="getProjectCriticalEventLogs")
    public ShortLogResponse<ShortLogEntryBase> getAllShortLogs(PublicProjectId project, @BeanParam LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, this.openEventLogIndexes(project));
    }

    @Override
    @Operation(summary="Get critical event detail log", description="Returns the detailed critical event log entry for the given timestamp.", tags={"Logging"}, operationId="getProjectCriticalEventLog")
    public DetailedServiceLog getDetailedLog(PublicProjectId project, LogEntryIdentifier logEntryIdentifier) throws StorageException {
        return (DetailedServiceLog)LogServiceUtils.getDetailedLogEntry(this.openEventLogIndexes(project), (LogEntryIdentifier)logEntryIdentifier);
    }

    @Override
    @Operation(summary="Get critical event log frequencies", description="Returns the frequencies of the various critical event log types (i.e. INFO/WARN/ERROR).", tags={"Logging"}, operationId="getProjectCriticalEventLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies(PublicProjectId project) throws StorageException {
        return LogServiceUtils.obtainFrequencies(this.openEventLogIndexes(project));
    }

    @Override
    @Operation(summary="Download critical event logs", description="Returns a file download of all critical event logs.", tags={"Logging"}, operationId="downloadProjectCriticalEventLogs")
    public Response downloadLog(PublicProjectId project, LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)"CriticalEventTeamscaleLogExport", (LogFilteringParameters)logFilteringParameters, (int)maxChars, this.openEventLogIndexes(project));
    }

    @Override
    @Operation(summary="Delete critical event logs", description="Deletes all log entries in the specified project that match the applied filters.", tags={"Logging"}, operationId="deleteProjectCriticalEventLogs")
    public void deleteLogEntries(PublicProjectId project, LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, this.openEventLogIndexes(project));
        AuditLogs.projectLogDeletion((String)"critical event logs", (PublicProjectId)project);
    }

    private LogIndexesWrapper<ShortCriticalEventServiceLog, DetailedServiceLog> openEventServiceLogIndexes(PublicProjectId project) throws StorageException {
        return new LogIndexesWrapper(PairList.from((Object)project, (Object)LogServiceUtils.determineIndexForProject((PublicProjectId)project, (IndexLayer)this.serviceInfo.getIndexLayer(), LogServiceUtils::getGlobalCriticalEventLogIndex, LogServiceUtils::getProjectCriticalEventLogIndex)));
    }

    private LogIndexesWrapper<ShortCriticalEventWorkerLog, DetailedWorkerLog> openEventWorkerLogIndexes(PublicProjectId project) throws StorageException {
        return new LogIndexesWrapper(PairList.from((Object)project, (Object)LogServiceUtils.determineIndexForProject((PublicProjectId)project, (IndexLayer)this.serviceInfo.getIndexLayer(), LogServiceUtils::getGlobalCriticalEventWorkerLogIndex, LogServiceUtils::getProjectCriticalEventWorkerLogIndex)));
    }

    private <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> openEventLogIndexes(PublicProjectId project) throws StorageException {
        LogIndexesWrapper<ShortCriticalEventServiceLog, DetailedServiceLog> serviceLogIndexes = this.openEventServiceLogIndexes(project);
        LogIndexesWrapper<ShortCriticalEventWorkerLog, DetailedWorkerLog> workerLogIndexes = this.openEventWorkerLogIndexes(project);
        PairList allProjectsAndIndexes = serviceLogIndexes.getAllProjectsAndIndexes();
        allProjectsAndIndexes.addAll(workerLogIndexes.getAllProjectsAndIndexes());
        return new LogIndexesWrapper(allProjectsAndIndexes);
    }
}

