/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.interaction.GlobalInteractionLogIndex;
import com.teamscale.core.log.profiler.GlobalProfilerLogIndex;
import com.teamscale.core.log.service.GlobalCriticalEventServiceLogIndex;
import com.teamscale.core.log.service.GlobalServiceLogIndex;
import com.teamscale.core.log.worker.GlobalCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogDigestIndex;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectCriticalEventWorkerLogIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogDigestIndex;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.log.worker.WorkerLogDigestIndexBase;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.user.ProjectUserActivityIndex;
import com.teamscale.index.admin.profiler.RunningProfilersIndex;
import com.teamscale.index.repository.sap.abapsystem.SapVersionIndex;
import com.teamscale.service.framework.logging.LogServiceUtils;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@PeriodicMaintenanceJob(cronExpression="0 * * * *")
public class OldLogsCleanupTrigger
extends MaintenanceTriggerBase {
    private static final int MAX_LOG_ENTRIES_PER_SEVERITY = 10000;
    private final int maxLogsToRetain;
    private static final Period USER_ACTIVITY_PURGE_THRESHOLD = Period.ofYears(2);

    public OldLogsCleanupTrigger() {
        this(10000);
    }

    private OldLogsCleanupTrigger(int maxLogsToRetain) {
        this.maxLogsToRetain = maxLogsToRetain;
    }

    public void execute() throws StorageException {
        GlobalStorageSystem globalPartition = this.indexLayer.openGlobalStorageSystem();
        ArrayList globalLogIndexes = new ArrayList();
        GlobalWorkerLogIndex globalWorkerLogIndex = (GlobalWorkerLogIndex)globalPartition.openGlobalIndex(GlobalWorkerLogIndex.class);
        globalLogIndexes.add((LogIndexBase)globalPartition.openGlobalIndex(GlobalServiceLogIndex.class));
        globalLogIndexes.add((LogIndexBase)globalPartition.openGlobalIndex(GlobalCriticalEventServiceLogIndex.class));
        globalLogIndexes.add((LogIndexBase<?, ?>)globalWorkerLogIndex);
        globalLogIndexes.add((LogIndexBase)globalPartition.openGlobalIndex(GlobalCriticalEventWorkerLogIndex.class));
        globalLogIndexes.add((LogIndexBase)globalPartition.openGlobalIndex(GlobalInteractionLogIndex.class));
        this.purgeIndexes(globalLogIndexes);
        WorkerLogDigestIndexBase workerLogDigestIndex = (WorkerLogDigestIndexBase)globalPartition.openGlobalIndex(GlobalWorkerLogDigestIndex.class);
        workerLogDigestIndex.purgeRemovedEntries((LogIndexBase)globalWorkerLogIndex);
        this.purgeProjectLogIndexes();
        ProjectUserActivityIndex projectUserActivityIndex = (ProjectUserActivityIndex)globalPartition.openGlobalIndex(ProjectUserActivityIndex.class);
        projectUserActivityIndex.purgeEntriesOlderThan(ZonedDateTime.now(ZoneOffset.UTC).minus(USER_ACTIVITY_PURGE_THRESHOLD).toInstant());
        SapVersionIndex sapVersionIndex = (SapVersionIndex)globalPartition.openGlobalIndex(SapVersionIndex.class);
        sapVersionIndex.removeDeletedSapConnections(this.getExistingSapConnectionIds());
        OldLogsCleanupTrigger.cleanupProfilerRunsAndTheirLogs(globalPartition);
    }

    private static void cleanupProfilerRunsAndTheirLogs(GlobalStorageSystem globalPartition) throws StorageException {
        GlobalProfilerLogIndex profilerLogIndex = (GlobalProfilerLogIndex)globalPartition.openGlobalIndex(GlobalProfilerLogIndex.class);
        RunningProfilersIndex runningProfilersIndex = (RunningProfilersIndex)globalPartition.openGlobalIndex(RunningProfilersIndex.class);
        RunningProfilersIndex.ProfilerLogCleanupLevels profilerRunsToClean = runningProfilersIndex.discardOutdatedProfilerRuns();
        profilerLogIndex.purgeOldLogs((Collection)profilerRunsToClean.pruneOldestEntriesFor(), (Collection)profilerRunsToClean.purgeCompletelyFor());
    }

    private void purgeProjectLogIndexes() throws StorageException {
        for (ProjectInfo project : ((ProjectIndex)this.indexLayer.openGlobalIndex(ProjectIndex.class)).getAllProjectInfos()) {
            InternalProjectId projectId = project.getInternalId();
            ArrayList projectIndexes = new ArrayList();
            ProjectWorkerLogIndex projectWorkerLogIndex = (ProjectWorkerLogIndex)this.indexLayer.openNonHistorizedProjectIndex(ProjectWorkerLogIndex.class, project);
            projectIndexes.add(LogServiceUtils.getProjectServiceLogIndex((IndexLayer)this.indexLayer, (IProjectId)projectId));
            projectIndexes.add((LogIndexBase<?, ?>)LogServiceUtils.getProjectCriticalEventLogIndex((IndexLayer)this.indexLayer, (IProjectId)projectId));
            projectIndexes.add((LogIndexBase<?, ?>)LogServiceUtils.getProjectInteractionLogIndex((IndexLayer)this.indexLayer, (IProjectId)projectId));
            projectIndexes.add((LogIndexBase<?, ?>)projectWorkerLogIndex);
            projectIndexes.add((LogIndexBase)this.indexLayer.openNonHistorizedProjectIndex(ProjectCriticalEventWorkerLogIndex.class, project));
            this.purgeIndexes(projectIndexes);
            ProjectWorkerLogDigestIndex projectLogDigestIndex = (ProjectWorkerLogDigestIndex)this.indexLayer.openNonHistorizedProjectIndex(ProjectWorkerLogDigestIndex.class, project);
            projectLogDigestIndex.purgeRemovedEntries((LogIndexBase)projectWorkerLogIndex);
        }
    }

    private Set<String> getExistingSapConnectionIds() throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.indexLayer.openGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        Set sapOptions = ServerOptionRegistry.getServerMultiOptionAll((String)"sap.abap.system", (ServerOptionIndex)serverOptionIndex).keySet();
        return CollectionUtils.mapToSet(sapOptions, name -> (String)OptionRegistryBase.extractOptionNameAndSelector((String)name).getSecond());
    }

    private void purgeIndexes(List<LogIndexBase<?, ?>> logIndexes) throws StorageException {
        for (LogIndexBase<?, ?> index : logIndexes) {
            index.purge(this.maxLogsToRetain);
        }
    }
}

