/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.merge_request.voting.PostponedVotingIndex;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.PrintWriter;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

@Path(value="api/projects/{project}/merge-requests/debug/postponed-votes")
public class DebugPostponedVotesService
extends DebugDumpServiceBase {
    @GET
    @Operation(summary="Get postponed votes", description="Returns all postponed votes for merge requests in the project.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getMergeRequestsWithPostponedVotes() throws StorageException {
        return this.getDebugDumpResults();
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        PostponedVotingIndex postponedVotingIndex = this.openProjectIndex(PostponedVotingIndex.class, null);
        writer.println("# Postponed Votes:");
        writer.println("===========================");
        postponedVotingIndex.getAllPostponedVotes().forEach(writer::println);
    }

    @DELETE
    @Operation(summary="Clear the entire PostponedVotingIndex", description="Deletes all stored postponed votes in the project by clearing the entire PostponedVotingIndex.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void clearIndex() throws StorageException {
        StorageUtils.clearStore((IStore)this.getProjectStorageSystem().openStore("postponed-votes"));
    }

    @POST
    @Path(value="{mergeRequestIdentifier}")
    @Operation(summary="Record postponed vote", description="Adds a postponed vote for the given merge request in the PostponedVotingIndex.")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void addPostponedVote(@PathParam(value="mergeRequestIdentifier") MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        PostponedVotingIndex postponedVotingIndex = this.openProjectIndex(PostponedVotingIndex.class, null);
        postponedVotingIndex.addPostponedVote(mergeRequestIdentifier);
    }
}

