/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.badge;

import com.teamscale.service.badge.MetricGroupBadgeQueryParams;
import com.teamscale.service.badge.StaticBadgeUtils;
import com.teamscale.service.badge.velocity.BadgeCreator;
import com.teamscale.service.badge.velocity.metric.MetricGroupBadgeData;
import org.apache.commons.text.StringEscapeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class MergeRequestMetricGroupBadgeCreator {
    private static final String SEGMENTED_METRIC_GROUP_BADGE_TEMPLATE_PATH = "com/teamscale/service/metrics/badge/segmented-metric-group-badge-template.svg";
    private final String groupName;
    private final int metricsWithoutData;
    private final int deterioratedMetrics;
    private final int stableMetrics;
    private final int improvedMetrics;
    private final int newThresholdViolations;
    private final boolean increasingValuesIndicateImprovement;
    private final String incompleteBuildText;

    public MergeRequestMetricGroupBadgeCreator(MetricGroupBadgeQueryParams queryParams) {
        this.groupName = queryParams.getMetricGroupName();
        this.metricsWithoutData = queryParams.getMetricsWithoutData();
        this.deterioratedMetrics = queryParams.getDeterioratedMetrics();
        this.stableMetrics = queryParams.getStableMetrics();
        this.improvedMetrics = queryParams.getImprovedMetrics();
        this.newThresholdViolations = queryParams.getNewThresholdViolations();
        this.increasingValuesIndicateImprovement = queryParams.isIncreasingValuesIndicateImprovement();
        this.incompleteBuildText = queryParams.getIncompleteBuildText();
    }

    public byte[] createBadge() {
        MetricGroupBadgeData badgeData = new MetricGroupBadgeData(this.increasingValuesIndicateImprovement);
        StaticBadgeUtils.appendBuildJobsSegment(badgeData, this.incompleteBuildText);
        badgeData.appendTitle(StringEscapeUtils.escapeXml11((String)this.groupName), "");
        if (this.metricsWithoutData > 0) {
            badgeData.appendSegmentForMetricsWithoutData(String.valueOf(this.metricsWithoutData));
        }
        if (this.deterioratedMetrics > 0) {
            badgeData.appendSegmentForDeterioratedMetrics(String.valueOf(this.deterioratedMetrics));
        }
        if (this.stableMetrics > 0) {
            badgeData.appendSegmentForStableMetrics(String.valueOf(this.stableMetrics));
        }
        if (this.improvedMetrics > 0) {
            badgeData.appendSegmentForImprovedMetrics(String.valueOf(this.improvedMetrics));
        }
        if (this.newThresholdViolations > 0) {
            badgeData.appendSegmentForThresholdViolations(String.valueOf(this.newThresholdViolations));
        }
        return StringUtils.stringToBytes((String)BadgeCreator.createBadge(SEGMENTED_METRIC_GROUP_BADGE_TEMPLATE_PATH, badgeData));
    }
}

