/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.table;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class MetricTableServiceParameters {
    @QueryParam(value="configuration-name")
    @Parameter(description="The name of the metric threshold configuration to use", required=true)
    public String thresholdConfigurationName;
    @QueryParam(value="limit-to-profile")
    @Parameter(description="Allows to return only the metrics that are in the threshold profile.")
    public boolean limitToProfile;
    @QueryParam(value="metrics")
    @Parameter(description="Allows to limit the considered metrics to the given list.")
    public List<String> metricsToConsider;
    @QueryParam(value="partition")
    @Parameter(description="Allows to specify which partitions should be considered. This only has an effect for test and test execution metrics.")
    private Set<String> partitions;
    @QueryParam(value="all-partitions")
    @Parameter(description="Includes data from all partitions.")
    private boolean allPartitions;
    @QueryParam(value="skip-rows-without-data")
    @Parameter(description="Skips rows that only consist of <null> entries")
    public boolean skipRowsWithoutData;

    public Optional<Set<String>> getPartitions() {
        if (this.allPartitions) {
            return Optional.empty();
        }
        return Optional.of(this.partitions);
    }
}

