/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import java.awt.Color;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class MetricTreemapBuilderParameters {
    public static final int DEFAULT_VALUE_LIMIT = -1;
    public final @Nullable Pattern includePattern;
    public final @Nullable Pattern excludePattern;
    public final int colorMetricIndex;
    public final Object colorMetricDefault;
    public final Color baseColor;
    private double customMinValue = -1.0;
    private double customMaxValue = -1.0;
    private boolean enableColorBlindMode;

    public MetricTreemapBuilderParameters(@Nullable Pattern includePattern, @Nullable Pattern excludePattern, int colorMetricIndex, Object colorMetricDefault, Color baseColor, double customMinValue, double customMaxValue, boolean enableColorBlindMode) {
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
        this.colorMetricIndex = colorMetricIndex;
        this.colorMetricDefault = colorMetricDefault;
        this.baseColor = baseColor;
        this.customMinValue = customMinValue;
        this.customMaxValue = customMaxValue;
        this.enableColorBlindMode = enableColorBlindMode;
    }

    public MetricTreemapBuilderParameters(Pattern includePattern, Pattern excludePattern, int colorMetricIndex, Object colorMetricDefault, Color baseColor) {
        this(includePattern, excludePattern, colorMetricIndex, colorMetricDefault, baseColor, -1.0, -1.0, false);
    }

    public MetricTreemapBuilderParameters(Pattern includePattern, Pattern excludePattern, int colorMetricIndex, Object colorMetricDefault, Color baseColor, boolean enableColorBlindMode) {
        this(includePattern, excludePattern, colorMetricIndex, colorMetricDefault, baseColor, -1.0, -1.0, enableColorBlindMode);
    }

    public boolean customMinimumValueDiffersFromDefault() {
        return this.customMinValue != -1.0;
    }

    public boolean customMaximumValueDiffersFromDefault() {
        return this.customMaxValue != -1.0;
    }

    public double getCustomMinValue() {
        return this.customMinValue;
    }

    public double getCustomMaxValue() {
        return this.customMaxValue;
    }

    public boolean isColorBlindModeEnabled() {
        return this.enableColorBlindMode;
    }
}

