/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class NumericValueTreeMapBuilderBase<T extends Number, Node extends TreeMapNode>
extends MetricTreemapBuilderBase<Node> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ARTIFICIAL_AREA_METRIC_INDEX = 0;
    private static final int ARTIFICIAL_VALUE_METRIC_INDEX = 1;
    protected final int originalAreaMetricIndex;
    private Map<String, T> valuesByUniformPath;

    protected NumericValueTreeMapBuilderBase(Pattern includePattern, Pattern excludePattern, HistoryAccessOption historyAccessOption, IMetricRetrievalStrategy metricRetrievalStrategy, int areaMetricIndex, Object colorMetricDefault, Color baseColor, double customMinValue, double customMaxValue, boolean enableColorBlindMode) {
        super(metricRetrievalStrategy, historyAccessOption, 0, new MetricTreemapBuilderParameters(includePattern, excludePattern, 1, colorMetricDefault, baseColor, customMinValue, customMaxValue, enableColorBlindMode));
        this.originalAreaMetricIndex = areaMetricIndex;
    }

    protected NumericValueTreeMapBuilderBase(Pattern includePattern, Pattern excludePattern, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, Object colorMetricDefault, Color baseColor, boolean enableColorBlindMode) {
        this(includePattern, excludePattern, historyAccessOption, metricRetrievalStrategy, areaMetricIndex, colorMetricDefault, baseColor, -1.0, -1.0, enableColorBlindMode);
    }

    @Override
    public Node buildTreeMap(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        this.valuesByUniformPath = this.calculateValues(uniformPath.toString());
        return (Node)super.buildTreeMap(uniformPath);
    }

    protected abstract Map<String, T> calculateValues(String var1) throws StorageException;

    @Override
    protected List<MetricDirectoryEntry> getEntriesFor(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        List<MetricDirectoryEntry> entries = super.getEntriesFor(uniformPath);
        return this.createArtificialEntries(entries);
    }

    @Override
    protected MetricDirectoryEntry createMetricDirectoryEntryWithDefaultValue(UniformPath uniformPath) throws StorageException {
        return this.createArtificialEntries(List.of(super.createMetricDirectoryEntryWithDefaultValue(uniformPath))).get(0);
    }

    protected List<MetricDirectoryEntry> createArtificialEntries(List<MetricDirectoryEntry> entries) {
        ListMap resultEntriesByParent = new ListMap();
        ArrayList<MetricDirectoryEntry> artificialEntries = new ArrayList<MetricDirectoryEntry>();
        boolean problemsLogged = false;
        for (MetricDirectoryEntry entry : CollectionUtils.asIterable(entries.stream().sorted(Comparator.reverseOrder()).iterator())) {
            if (entry == null || entry.getValueWithoutNullAssert(this.originalAreaMetricIndex) == null) {
                if (problemsLogged) continue;
                this.logMissingOrIncompleteEntry(entry);
                problemsLogged = true;
                continue;
            }
            List<MetricDirectoryEntry> childEntries = (List<MetricDirectoryEntry>)resultEntriesByParent.getCollection((Object)entry.getUniformPath());
            if (childEntries == null) {
                childEntries = Collections.emptyList();
            }
            MetricDirectoryEntry resultEntry = this.createResultEntry(entry, childEntries, this.originalAreaMetricIndex, (Number)this.valuesByUniformPath.get(entry.getUniformPath()));
            artificialEntries.add(resultEntry);
            if (entry.getUniformPath().isEmpty()) continue;
            resultEntriesByParent.add((Object)UniformPathUtils.getParentPath((String)entry.getUniformPath()), (Object)resultEntry);
        }
        return CollectionUtils.reverse(artificialEntries);
    }

    private void logMissingOrIncompleteEntry(MetricDirectoryEntry entry) {
        if (entry == null) {
            LOGGER.error("Encountered missing entry");
        } else {
            LOGGER.error("Encountered incomplete entry: " + String.valueOf(entry));
        }
    }

    private MetricDirectoryEntry createResultEntry(MetricDirectoryEntry entry, Collection<MetricDirectoryEntry> childEntries, int areaMetric, T value) {
        Object[] metrics = new Object[]{entry.hasChildren() ? NumericValueTreeMapBuilderBase.getMetricValueSum(childEntries, 0) : entry.getValue(areaMetric), value == null ? Double.valueOf(0.0) : Double.valueOf(((Number)value).doubleValue())};
        MetricDirectoryEntry aggregatedEntry = new MetricDirectoryEntry(entry.getUniformPath(), metrics);
        for (MetricDirectoryEntry childEntry : childEntries) {
            aggregatedEntry.insertOrUpdateChild(childEntry);
        }
        return aggregatedEntry;
    }

    private static Double getMetricValueSum(Collection<MetricDirectoryEntry> entries, int metricIndex) {
        double result = 0.0;
        for (MetricDirectoryEntry child : entries) {
            result += child.getDoubleValue(metricIndex);
        }
        return result;
    }
}

