/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import io.prometheus.metrics.model.snapshots.Unit;
import java.util.Objects;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public class ArtifactStoreSizeMetricCollector
extends IndexCallbackMetricsProviderBase {
    public ArtifactStoreSizeMetricCollector(IndexLayer indexLayer) {
        super(indexLayer);
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("artifact_storage_size")).labelNames(new String[]{"project", "connector", "type"})).unit(Unit.BYTES)).help("Size of artifacts stored in the artifact store.")).callback(this::collectMetricsForProject).register();
    }

    private void collectMetricsForProject(GaugeWithCallback.Callback cb) {
        this.doForAllProjects(ArtifactStoreSizeMetricCollector::collectArtifactStoreMetricsForExternalStorageBackend, (projectId, artifactSizesByRepoIdentifier) -> ArtifactStoreSizeMetricCollector.consumeArtifactSizes(projectId, "external-analysis-data", artifactSizesByRepoIdentifier, cb));
        this.doForAllConnectors(ArtifactStoreSizeMetricCollector::collectArtifactStoreMetricsForConnector, (projectAndConnector, artifactSizes) -> ArtifactStoreSizeMetricCollector.consumeArtifactSizes((PublicProjectId)projectAndConnector.getFirst(), (String)projectAndConnector.getSecond(), artifactSizes, cb));
    }

    private static void consumeArtifactSizes(PublicProjectId projectId, String connectorIdentifier, ArtifactSizes artifactSizes, GaugeWithCallback.Callback cb) {
        if (artifactSizes == null) {
            return;
        }
        cb.call((double)artifactSizes.totalSize(), new String[]{projectId.projectId, connectorIdentifier, "total"});
        cb.call((double)artifactSizes.analyzedSize(), new String[]{projectId.projectId, connectorIdentifier, "used"});
        cb.call((double)artifactSizes.garbageSize(), new String[]{projectId.projectId, connectorIdentifier, "garbage"});
    }

    private static @Nullable ArtifactSizes collectArtifactStoreMetricsForExternalStorageBackend(ProjectStorageSystem projectStorageSystem) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem);
        if (projectConfiguration == null || projectConfiguration.getExternalStorageBackend() != null) {
            S3ArchiveIndex s3ArchiveIndex = (S3ArchiveIndex)projectStorageSystem.openProjectIndex(S3ArchiveIndex.class, S3ArchiveIndex.createIndexName((String)"external-analysis-data"), null);
            return ArtifactStoreSizeMetricCollector.reportMetricFromArchiveIndex(s3ArchiveIndex);
        }
        return null;
    }

    private static @Nullable ArtifactSizes collectArtifactStoreMetricsForConnector(IndexCallbackMetricsProviderBase.ProjectConnectorCallbackInfo callbackInfo) throws StorageException {
        if (!callbackInfo.connector().isRepositoryType(ERepositoryConnector.S3)) {
            return null;
        }
        return ArtifactStoreSizeMetricCollector.handleS3Connector(callbackInfo);
    }

    private static ArtifactSizes handleS3Connector(IndexCallbackMetricsProviderBase.ProjectConnectorCallbackInfo callbackInfo) throws StorageException {
        ProjectStorageSystem projectStorageSystem = callbackInfo.projectStorageSystem();
        ConnectorConfiguration connectorConfig = callbackInfo.connector();
        S3ArchiveIndex s3ArchiveIndex = (S3ArchiveIndex)projectStorageSystem.openProjectIndex(S3ArchiveIndex.class, S3ArchiveIndex.createIndexName((String)connectorConfig.getIdentifier()), null);
        return ArtifactStoreSizeMetricCollector.reportMetricFromArchiveIndex(s3ArchiveIndex);
    }

    private static ArtifactSizes reportMetricFromArchiveIndex(S3ArchiveIndex s3ArchiveIndex) throws StorageException {
        long totalArtifactStoreSize = Objects.requireNonNullElse(s3ArchiveIndex.getTotalArtifactStoreSize(), 0L);
        long analyzedArtifactStoreSize = Objects.requireNonNullElse(s3ArchiveIndex.getAnalyzedArtifactStoreSize(), 0L);
        long garbageArtifactStoreSize = Objects.requireNonNullElse(s3ArchiveIndex.getGarbageArtifactStoreContentSize(), 0L);
        return new ArtifactSizes(totalArtifactStoreSize, analyzedArtifactStoreSize, garbageArtifactStoreSize);
    }

    private record ArtifactSizes(long totalSize, long analyzedSize, long garbageSize) {
    }
}

