/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.option;

import com.teamscale.core.cron.CronExpression;
import com.teamscale.core.cron.InvalidCronPatternException;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.LateExternalUploadScheduleOption;
import com.teamscale.service.external.input.RejectOldUploadsOption;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.option.LateExternalUploadProcessingInfo;
import com.teamscale.service.option.OptionServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.eclipse.jgit.util.StringUtils;

@Path(value="api/projects/{project}/late-external-upload")
public class LateExternalUploadInfoService
extends OptionServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get the late external upload information", description="Retrieves the timestamp of the next late processing of external uploads, the age threshold for external uploads being considered late and the maximum upload age for external uploads.", tags={"Administration"})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public LateExternalUploadProcessingInfo getLateExternalUploadProcessingInfo() throws Exception {
        Long nextLateProcessingTimestamp = this.getNextLateProcessingTimestamp();
        Integer lateProcessingAgeThreshold = this.getLateProcessingAgeThreshold();
        Integer maxUploadAge = this.getMaxUploadAge();
        return new LateExternalUploadProcessingInfo(nextLateProcessingTimestamp, lateProcessingAgeThreshold, maxUploadAge);
    }

    private Long getNextLateProcessingTimestamp() throws Exception {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        String uploadSchedule = LateExternalUploadScheduleOption.getUploadSchedule((ServerOptionIndex)serverOptionIndex);
        if (StringUtils.isEmptyOrNull((String)uploadSchedule)) {
            return null;
        }
        try {
            Optional nextExecution = CronExpression.parse((String)uploadSchedule).nextExecution();
            if (nextExecution.isEmpty()) {
                LOGGER.warn("Could not map cron expression to next execution timestamp: '{}'.", (Object)uploadSchedule);
                return null;
            }
            return ((ZonedDateTime)nextExecution.get()).toInstant().toEpochMilli();
        }
        catch (InvalidCronPatternException e) {
            LOGGER.warn("Could not parse cron expression '{}'", (Object)uploadSchedule, (Object)e);
            return null;
        }
    }

    private Integer getLateProcessingAgeThreshold() throws Exception {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        return LateExternalUploadScheduleOption.getAgeThreshold((ServerOptionIndex)serverOptionIndex);
    }

    private Integer getMaxUploadAge() throws StorageException {
        ProjectOptionIndex projectOptionIndex = this.openProjectIndex(ProjectOptionIndex.class, null);
        RejectOldUploadsOption rejectOldUploadsOption = (RejectOldUploadsOption)ProjectOptionRegistry.getInstance().getOption("<p>", "upload.max-age", null, RejectOldUploadsOption.class, (OptionIndexBase)projectOptionIndex);
        String maxUploadDays = rejectOldUploadsOption.maxUploadDays;
        if (StringUtils.isEmptyOrNull((String)maxUploadDays)) {
            return null;
        }
        return Integer.valueOf(maxUploadDays);
    }
}

