/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.persistence;

import com.teamscale.service.base.ApiBase;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public abstract class StoreImportServiceBase
extends ApiBase {
    protected static String importStores(String directoryPath, SchemaAwareStorageSystem storageSystem) throws StorageException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        File directory = new File(directoryPath);
        writer.println("Importing from " + directory.getAbsolutePath());
        try {
            File[] files = directory.listFiles();
            if (files == null) {
                throw new StorageException("Not a valid directory: " + String.valueOf(directory));
            }
            for (File file : files) {
                if (!file.isFile() || !file.canRead()) continue;
                String name = file.getName();
                try (DataInputStream in = new DataInputStream(FileSystemUtils.autoDecompressStream((InputStream)new BufferedInputStream(new FileInputStream(file))));){
                    int numEntries = StorageUtils.importStore((IStore)storageSystem.openStore(name), (DataInputStream)in);
                    writer.println("Read " + numEntries + " entries for " + name);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(writer);
        }
        writer.close();
        return stringWriter.toString();
    }
}

