/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/connectors/git")
public class GitConnectorsService
extends ApiBase {
    @GET
    @Path(value="connector-ids")
    @Operation(summary="Get connector ids of all Git-based connectors", description="Returns all connector identifiers in a project that use Git.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<String> getGitConnectorIds(@PathParam(value="project") PublicProjectId projectId) throws StorageException, ProjectConfigurationException {
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectId, (IndexLayer)this.getIndexLayer());
        if (projectConfiguration == null) {
            throw new InternalServerErrorException("Project with id '" + String.valueOf(projectId) + "' was not found.");
        }
        ConfigurationInitializationContext initializationContext = new ConfigurationInitializationContext(this.getIndexLayer(), (IExternalCredentialsProvider)this.openGlobalIndex(ExternalCredentialsIndex.class));
        ArrayList<String> gitConnectorIds = new ArrayList<String>();
        for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
            ConnectorDescriptorBase descriptor = ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)initializationContext, (InternalProjectId)projectConfiguration.getInternalId());
            if (!(descriptor instanceof GitRepositoryConnectorDescriptor)) continue;
            gitConnectorIds.add(connector.getIdentifier());
        }
        return gitConnectorIds;
    }
}

