/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public interface IProjectUserActivityServiceApi {
    public static final String PROJECTS_PARAMETER = "project-ids";
    public static final String AGGREGATE_PARAMETER = "aggregate";
    public static final String EXCLUDED_GROUPS_PARAMETER = "exclude-group";

    @GET
    @Path(value="/aggregated")
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_USER_STATISTICS})
    @Operation(summary="Get unique users count", description="Returns the number of unique users between the day of the given start timestamp (inclusive) and the day of the given end timestamp (inclusive). There are two ways in which you can call this service: 1) Provide only the baseline timestamp to get the number of unique users on the day of the timestamp. 2) Provide a baseline and end timestamp to get the number of unique users on every day from start of the day of the baseline to the end of the day of the end timestamp")
    public Integer getNumberOfUniqueUsers(@QueryParam(value="project-ids") @Parameter(description="List of all ids of the projects.") List<String> var1, @QueryParam(value="baseline") @Parameter(description="The baseline commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"", required=true) Long var2, @QueryParam(value="end") @Parameter(description="The end commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\" If this is not given, only one trend entry will be returned, which is for the day on which the given baseline timestamp lies.") @DefaultValue(value="-1") long var3, @QueryParam(value="exclude-group") @Parameter(description="Users in these groups are ignored in the user count. Group names can contain spaces.") List<String> var5) throws StorageException;

    @GET
    @Path(value="/trend")
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_USER_STATISTICS})
    @Operation(summary="Get unique users activity trend", description="Returns a list of lists, where each list contains a pair of the date timestamp and the number of unique users on that date.")
    public List<List<Number>> getProjectUserActivityTrend(@QueryParam(value="project-ids") @Parameter(description="List of all ids of the projects.") List<String> var1, @QueryParam(value="baseline") @Parameter(description="The baseline commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"", required=true) Long var2, @QueryParam(value="end") @Parameter(description="The end commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\" If this is not given, only one trend entry will be returned, which is for the day on which the given baseline timestamp lies.") @DefaultValue(value="-1") long var3, @QueryParam(value="exclude-group") @Parameter(description="Users in these groups are ignored in the user count. Group names can contain spaces.") List<String> var5) throws StorageException;
}

