/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.EConnectorType;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.GitHubRepositoryConnectorUrl;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.project.ReanalyzeProjectTrigger;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.AnalysisProfileValidationResult;
import com.teamscale.index.configuration.ProjectValidationUtils;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ProjectServiceUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void validateIdentifiers(ProjectConfiguration projectConfiguration) throws BadRequestException {
        Optional errorMessage = projectConfiguration.validateIdentifiers();
        if (errorMessage.isPresent()) {
            throw new BadRequestException("Project could not be created. " + (String)errorMessage.get());
        }
    }

    public static boolean connectorsRequireReAnalysis(List<ConnectorDescriptorBase> newConnectors, List<ConnectorDescriptorBase> oldConnectors) {
        int numberOfOldIssueTrackers;
        Map<String, List<ConnectorDescriptorBase>> newConnectorsById = newConnectors.stream().collect(Collectors.groupingBy(ProjectServiceUtils::getConnectorId));
        Map<String, List<ConnectorDescriptorBase>> oldConnectorsById = oldConnectors.stream().collect(Collectors.groupingBy(ProjectServiceUtils::getConnectorId));
        for (Map.Entry<String, List<ConnectorDescriptorBase>> entry : oldConnectorsById.entrySet()) {
            if (!ProjectServiceUtils.connectorsWithSameIdRequireReanalysis(newConnectorsById.get(entry.getKey()), entry.getValue())) continue;
            return true;
        }
        int numberOfNewIssueTrackers = newConnectorsById.getOrDefault(EConnectorType.ISSUE_TRACKER.name(), List.of()).size();
        return numberOfNewIssueTrackers > (numberOfOldIssueTrackers = oldConnectorsById.getOrDefault(EConnectorType.ISSUE_TRACKER.name(), List.of()).size());
    }

    private static boolean connectorsWithSameIdRequireReanalysis(List<ConnectorDescriptorBase> newConnectors, List<ConnectorDescriptorBase> oldConnectors) {
        if (newConnectors == null || newConnectors.size() < oldConnectors.size()) {
            return true;
        }
        for (int i = 0; i < oldConnectors.size(); ++i) {
            try {
                if (!ProjectServiceUtils.connectorRequiresReAnalysis(oldConnectors.get(i), newConnectors.get(i))) continue;
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                LOGGER.warn("Exception during comparison of old and updated connector: " + e.getMessage() + "\n" + Arrays.toString(e.getStackTrace()));
            }
        }
        return false;
    }

    private static String getConnectorId(ConnectorDescriptorBase connector) {
        return connector.getConnectorType().name() + "/" + connector.getConnectorIdentifier();
    }

    private static boolean connectorRequiresReAnalysis(ConnectorDescriptorBase connectorBefore, ConnectorDescriptorBase connectorAfter) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        for (Field field : ReflectionUtils.getAllFields(connectorAfter.getClass())) {
            if (!ProjectServiceUtils.fieldChangeRequiresReAnalysis(field)) continue;
            field.setAccessible(true);
            Object newValue = field.get(connectorAfter);
            Field oldField = ReflectionUtils.getField(connectorBefore.getClass(), (String)field.getName());
            if (oldField == null) {
                return true;
            }
            oldField.setAccessible(true);
            Object oldValue = oldField.get(connectorBefore);
            if (ProjectServiceUtils.fieldValuesAreEqual(oldValue, newValue) || ProjectServiceUtils.isGitHubServerURLOnlyTrailingSlashAdded(connectorAfter, field.getName(), oldValue, newValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean isGitHubServerURLOnlyTrailingSlashAdded(ConnectorDescriptorBase connector, String fieldName, Object oldValue, Object newValue) {
        if (connector.getName().equals(ERepositoryConnector.GITHUB.getReadableName()) && fieldName.equals("gitHubServerUrl")) {
            String newServerURL = ((GitHubRepositoryConnectorUrl)newValue).url();
            String oldServerURL = ((GitHubRepositoryConnectorUrl)oldValue).url();
            return newServerURL.length() == oldServerURL.length() + 1 && newServerURL.charAt(newServerURL.length() - 1) == '/';
        }
        return false;
    }

    private static boolean fieldValuesAreEqual(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null || newValue == null) {
            return StringUtils.safeToString((Object)oldValue).equals(StringUtils.safeToString((Object)newValue));
        }
        return oldValue.equals(newValue);
    }

    private static boolean fieldChangeRequiresReAnalysis(Field field) {
        ConfigExposed exposedConfig = field.getAnnotation(ConfigExposed.class);
        return exposedConfig != null && exposedConfig.changeRequiresReAnalysis();
    }

    public static void triggerReanalysis(InternalProjectId projectId, ITeamscaleServiceInfo serviceInfo, boolean validateProject) throws StorageException {
        IndexLayer indexLayer = serviceInfo.getIndexLayer();
        ProjectServiceUtils.triggerReanalysis(projectId, indexLayer, validateProject);
    }

    public static void triggerReanalysis(InternalProjectId projectId, IndexLayer indexLayer, boolean validateProject) throws StorageException {
        ProjectIndex projectIndex = indexLayer.openProjectIndex();
        ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)projectId);
        projectInfo.setReanalyzing(true);
        projectIndex.setProject(projectInfo);
        try {
            GlobalStorageSystem globalStorageSystem = indexLayer.openGlobalStorageSystem();
            ConfigurationInitializationContext context = new ConfigurationInitializationContext(null, indexLayer, (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.PROJECT_REANALYSIS);
            MetaIndex projectMetaIndex = (MetaIndex)indexLayer.openProjectStorageSystem((IProjectId)projectId).openProjectIndex(MetaIndex.class, null);
            ProjectServiceUtils.updateAnalysisProfiles(indexLayer, validateProject, projectMetaIndex, globalStorageSystem);
            if (validateProject) {
                ProjectValidationUtils.validateConnectorsInProject((IProjectId)projectId, (IndexLayer)indexLayer, (ConfigurationInitializationContext)context);
            }
        }
        catch (ProjectConfigurationException | StorageException e) {
            projectInfo.setReanalyzing(false);
            projectIndex.setProject(projectInfo);
            String message = "Message: Project " + String.valueOf(projectInfo.getPrimaryPublicId()) + ": " + e.getMessage();
            throw new BadRequestException(message, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build());
        }
        ProjectSchedulingFilter.resumeProjectIfPaused((InternalProjectId)projectInfo.getInternalId(), (GlobalStorageSystem)indexLayer.openGlobalStorageSystem());
        JobDescriptor reanalyzeJob = new JobDescriptor(projectInfo.getInternalId(), ReanalyzeProjectTrigger.class, null, "User triggered re-analysis of project '" + String.valueOf(projectInfo.getPrimaryPublicId()) + "'.");
        ISchedulerCommunicator.getInstance().scheduleExternalJob(indexLayer, reanalyzeJob);
    }

    private static void updateAnalysisProfiles(IndexLayer indexLayer, boolean validateProject, MetaIndex projectMetaIndex, GlobalStorageSystem globalStorageSystem) throws StorageException {
        AnalysisProfileValidationResult analysisProfileValidationResult;
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        ArrayList<AnalysisProfile> updatedAnalysisProfiles = new ArrayList<AnalysisProfile>();
        for (CodeScope codeScope : projectConfiguration.getCodeScopes()) {
            CCSMAssert.isNotNull((Object)codeScope.getEmbeddedProfile(), (String)"expected embedded profile for code scope %s to exist during reanalysis".formatted(codeScope.getName()));
            AnalysisProfile updatedAnalysisProfile = AnalysisProfileUtils.updateAnalysisProfile((AnalysisProfileIndex)((AnalysisProfileIndex)indexLayer.openGlobalIndex(AnalysisProfileIndex.class)), (MetaIndex)projectMetaIndex, (ProjectConfiguration)projectConfiguration, (String)codeScope.getEmbeddedProfile().getName());
            updatedAnalysisProfiles.add(updatedAnalysisProfile);
        }
        if (validateProject && (analysisProfileValidationResult = ProjectValidationUtils.validateAnalysisProfiles(updatedAnalysisProfiles, (GlobalStorageSystem)globalStorageSystem, (boolean)true)) != null) {
            throw new StorageException(analysisProfileValidationResult.getMessage());
        }
    }

    private ProjectServiceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

