/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.branch_tags;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionParameterType;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.OptionParameterType;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.project.ProjectOptionRegistry;
import com.teamscale.service.project.branch_tags.BranchTagSupplier;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="branch.tags", name="Branch Tags", type=EOptionType.PROJECT, category=EOptionCategory.OTHER, orderingHint=3000)
@IndexValueClass(containedInBackup=true)
public class BranchTagsOption
implements IOption {
    public static final String OPTION_ID = "branch.tags";
    public static final String OPTION_NAME = "Branch Tags";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="branchTags")
    @OptionFieldDescription(name="This option allows you to highlight special branches based on their name.", description="The left side of the mapping represents a tag that will be shown in the branch selector next to the branch name. The right side is a regex describing the branch names that should receive this tag.")
    @OptionParameterType(value=EOptionParameterType.PAIRLIST_STRING_STRING)
    public PairList<String, String> branchTags = new PairList();

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String validationResult = this.branchTags.stream().map(BranchTagsOption::validatePair).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        return StringUtils.isEmpty((String)validationResult) ? null : validationResult;
    }

    private static String validatePair(Pair<String, String> pair) {
        String tagName = (String)pair.getFirst();
        String regex = (String)pair.getSecond();
        if (StringUtils.isEmpty((String)tagName)) {
            return "Branch tag name cannot be empty";
        }
        if (StringUtils.isEmpty((String)regex)) {
            return "Branch regex pattern cannot be empty";
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            return String.format("Invalid regex pattern for tag '%s': %s", tagName, e.getMessage());
        }
        return null;
    }

    public BranchTagSupplier getBranchTagSupplier() {
        return new BranchTagSupplier(this.branchTags);
    }

    public static BranchTagsOption getBranchTagsOption(ProjectOptionIndex projectOptionIndex) throws StorageException {
        BranchTagsOption option = (BranchTagsOption)ProjectOptionRegistry.getInstance().getOption("<p>", OPTION_ID, null, BranchTagsOption.class, (OptionIndexBase)projectOptionIndex);
        return option != null ? option : new BranchTagsOption();
    }
}

