/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.project_creation_wizard;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class ImportantBranchCalculator {
    private static final List<Pattern> COMMON_IMPORTANT_BRANCH_PATTERNS = List.of(Pattern.compile("main"), Pattern.compile("trunk"), Pattern.compile("master"), Pattern.compile("develop"), Pattern.compile("dev"), Pattern.compile("rel/.*"), Pattern.compile("release/.*"), Pattern.compile("maintenance"));
    private final List<String> mergeTargets;
    private final List<String> allBranches;
    private final List<String> protectedBranches;

    public ImportantBranchCalculator(List<String> mergeTargets, List<String> allBranches, List<String> protectedBranches) {
        this.mergeTargets = mergeTargets;
        this.allBranches = allBranches;
        this.protectedBranches = protectedBranches;
    }

    public List<String> getImportantBranchPattern() {
        ArrayList<String> importantBranchPatterns = new ArrayList<String>();
        importantBranchPatterns.addAll(this.getUsedCommonImportantBranchPatterns());
        importantBranchPatterns.addAll(this.getProtectedBranchPatterns());
        importantBranchPatterns.addAll(this.getCommonMergeTargetPatterns());
        return importantBranchPatterns;
    }

    private List<String> getUsedCommonImportantBranchPatterns() {
        ArrayList<String> importantBranchPatterns = new ArrayList<String>();
        for (Pattern pattern : COMMON_IMPORTANT_BRANCH_PATTERNS) {
            if (!this.allBranches.stream().anyMatch(branch -> pattern.matcher((CharSequence)branch).matches())) continue;
            importantBranchPatterns.add(pattern.pattern());
        }
        return importantBranchPatterns;
    }

    private List<String> getProtectedBranchPatterns() {
        ArrayList<String> protectedBranchPatterns = new ArrayList<String>();
        List<String> prefixes = ImportantBranchCalculator.calculatePrefixesOfBranches(this.protectedBranches);
        for (String prefix : prefixes) {
            String pattern = prefix + ".*";
            if (!ImportantBranchCalculator.isNoCommonPattern(pattern)) continue;
            protectedBranchPatterns.add(pattern);
        }
        for (String protectedBranch : this.protectedBranches) {
            if (!ImportantBranchCalculator.matchesNoCommonPattern(protectedBranch)) continue;
            if (!prefixes.stream().noneMatch(protectedBranch::startsWith)) continue;
            protectedBranchPatterns.add(protectedBranch);
        }
        return protectedBranchPatterns;
    }

    private List<String> getCommonMergeTargetPatterns() {
        HashSet<String> protectedBranchesSet = new HashSet<String>(this.protectedBranches);
        CounterSet mergeTargetsWithCount = (CounterSet)this.mergeTargets.stream().filter(branch -> !protectedBranchesSet.contains(branch)).collect(CounterSet.toCounterSet());
        List<String> prefixes = ImportantBranchCalculator.calculatePrefixesOfBranches(mergeTargetsWithCount.stream().filter(ImportantBranchCalculator.onlyKeepReappearingMergeTargets((CounterSet<String>)mergeTargetsWithCount)).map(ImmutablePair::getFirst).toList());
        List<String> importantBranches = mergeTargetsWithCount.stream().filter(ImportantBranchCalculator.onlyKeepReappearingMergeTargets((CounterSet<String>)mergeTargetsWithCount)).filter(target -> prefixes.stream().noneMatch(prefix -> ((String)target.getFirst()).startsWith((String)prefix))).sorted(Comparator.comparing(ImmutablePair::getSecond, Integer::compare)).map(ImmutablePair::getFirst).toList();
        ArrayList<String> commonMergeTargetPatterns = new ArrayList<String>();
        for (String prefix : prefixes) {
            String pattern = prefix + ".*";
            if (!ImportantBranchCalculator.isNoCommonPattern(pattern)) continue;
            commonMergeTargetPatterns.add(pattern);
        }
        for (String commonMergeTarget : importantBranches) {
            if (!ImportantBranchCalculator.matchesNoCommonPattern(commonMergeTarget)) continue;
            commonMergeTargetPatterns.add(commonMergeTarget);
        }
        return commonMergeTargetPatterns;
    }

    private static List<String> calculatePrefixesOfBranches(List<String> branches) {
        CounterSet prefixes = new CounterSet();
        branches.forEach(branch -> prefixes.inc((Object)(StringUtils.getFirstPart((String)branch, (char)'/') + "/")));
        branches.forEach(branch -> {
            String prefix = ImportantBranchCalculator.getPrefixBeforeFirstNumber(branch);
            if (prefix.contains("/")) {
                return;
            }
            prefixes.inc((Object)prefix);
        });
        List<String> importantPrefixes = prefixes.stream().filter(pair -> (Integer)pair.getSecond() > 1).sorted(Comparator.comparing(ImmutablePair::getSecond, Integer::compare)).map(ImmutablePair::getFirst).toList();
        return ImportantBranchCalculator.removePrefixDuplication(importantPrefixes);
    }

    private static String getPrefixBeforeFirstNumber(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            return string.substring(0, i);
        }
        return string;
    }

    private static List<String> removePrefixDuplication(List<String> prefixes) {
        ArrayList<String> result = new ArrayList<String>();
        for (String prefix : prefixes) {
            if (!prefixes.stream().noneMatch(other -> prefix.startsWith((String)other) && !prefix.equals(other))) continue;
            result.add(prefix);
        }
        return result;
    }

    private static boolean matchesNoCommonPattern(String commonMergeTarget) {
        return COMMON_IMPORTANT_BRANCH_PATTERNS.stream().noneMatch(pattern -> pattern.matcher(commonMergeTarget).matches());
    }

    private static boolean isNoCommonPattern(String pattern) {
        return COMMON_IMPORTANT_BRANCH_PATTERNS.stream().noneMatch(commonPattern -> commonPattern.pattern().equals(pattern));
    }

    private static Predicate<Pair<String, Integer>> onlyKeepReappearingMergeTargets(CounterSet<String> allMergeTargets) {
        return target -> (double)((Integer)target.getSecond()).intValue() >= Math.min((double)allMergeTargets.getTotal() * 0.05, 5.0);
    }
}

