/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.project_creation_wizard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;

public record ProjectLanguage(@JsonProperty String language, @JsonProperty double usagePercentage, @JsonProperty boolean isSupported) {
    private static ProjectLanguage createInstance(String languageName, double usage) {
        List supportedLanguages = AnalysisProfileUtils.getSupportedLanguages();
        for (ELanguage supportedLanguage : supportedLanguages) {
            if (!ProjectLanguage.isSupported(languageName, supportedLanguage)) continue;
            return new ProjectLanguage(supportedLanguage.name(), usage, true);
        }
        return new ProjectLanguage(languageName, usage, false);
    }

    private static boolean isSupported(String languageName, ELanguage supportedLanguage) {
        return supportedLanguage.name().equalsIgnoreCase(languageName) || Arrays.stream(supportedLanguage.getReadableName().split("/")).anyMatch(readableName -> readableName.equalsIgnoreCase(languageName)) || Arrays.stream(supportedLanguage.getFileExtensions()).anyMatch(extension -> languageName.equalsIgnoreCase((String)extension));
    }

    public static List<ProjectLanguage> fromGitLab(Map<String, Double> languagesMapFromGitLab) throws StorageException {
        return languagesMapFromGitLab.entrySet().stream().map(entry -> ProjectLanguage.createInstance((String)entry.getKey(), (Double)entry.getValue())).collect(Collectors.toMap(ProjectLanguage::language, projectLanguage -> projectLanguage, (v1, v2) -> new ProjectLanguage(v1.language, v1.usagePercentage + v2.usagePercentage, v1.isSupported))).values().stream().toList();
    }

    public static List<ProjectLanguage> fromGitHub(Map<String, Long> languages) {
        long total = languages.values().stream().mapToLong(Long::longValue).sum();
        return languages.entrySet().stream().map(entry -> ProjectLanguage.createInstance((String)entry.getKey(), (double)((Long)entry.getValue()).longValue() / (double)total * 100.0)).collect(Collectors.toMap(ProjectLanguage::language, projectLanguage -> projectLanguage, (v1, v2) -> new ProjectLanguage(v1.language, v1.usagePercentage + v2.usagePercentage, v1.isSupported))).values().stream().toList();
    }
}

