/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.quality_report.ImageSlideIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.digest.Digester;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.jspecify.annotations.NonNull;

@Path(value="api/reports/{reportId}/images")
public class ReportImageService
extends ApiBase {
    public static @NonNull String getFullUrlForImageKey(String reportId, String imageKey) {
        if (StringUtils.isEmpty((String)imageKey)) {
            return "";
        }
        return "api/reports/" + reportId + "/images/" + imageKey;
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/octet-stream"})
    @Operation(summary="Returns an image that has been stored previously using this service", tags={"Reporting"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, entityPathParameter="reportId", permissions={EBasicPermission.VIEW})
    public Response getSlideImage(@Parameter(description="The unique image id that was returned by the POST call to this service.") @PathParam(value="id") String imageId) throws StorageException {
        ImageSlideIndex imageSlideIndex = this.openGlobalIndex(ImageSlideIndex.class);
        byte[] image = imageSlideIndex.getSlideImage(imageId);
        if (image == null || image.length == 0) {
            throw new BadRequestException("Requested image not found on server");
        }
        return Response.ok().entity(output -> {
            output.write(image);
            output.flush();
        }).build();
    }

    @POST
    @Operation(summary="Stores the passed image and returns a unique key to reference it in future scenarios", tags={"Reporting"})
    @Consumes(value={"multipart/form-data"})
    @RequiresBasicPermission(scope=EBasicPermissionScope.REPORTS, entityPathParameter="reportId", permissions={EBasicPermission.EDIT})
    public synchronized String uploadSlideImage(@FormDataParam(value="slide-image") InputStream uploadedImageInputStream) throws StorageException {
        ImageSlideIndex imageSlideIndex = this.openGlobalIndex(ImageSlideIndex.class);
        try {
            byte[] imageData = FileSystemUtils.readStreamBinary((InputStream)uploadedImageInputStream);
            if (imageData.length == 0 || imageData.length == 4 && StringUtils.bytesToString((byte[])imageData).equalsIgnoreCase("null")) {
                throw new BadRequestException("No valid imageData file upload given");
            }
            String imageId = Digester.createMD5Digest((byte[])imageData);
            imageSlideIndex.storeSlideImage(imageId, imageData);
            return imageId;
        }
        catch (IOException ex) {
            throw new InternalServerErrorException("Could not read uploaded image file", (Throwable)ex);
        }
    }
}

