/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.List;

public class BranchesServiceRequestOptions {
    private static final String START_OFFSET_PARAMETER_DESCRIPTION = "The offset from which to start loading branches.";
    private static final String START_OFFSET_PARAMETER_NAME = "start-offset";
    private static final String LIMIT_PARAMETER_DESCRIPTION = "The number of branches that should be returned.";
    private static final String LIMIT_PARAMETER_NAME = "limit";
    private static final String IS_ONLY_LIVE_BRANCHES_PARAMETER_DESCRIPTION = "Whether only currently live branches should be returned.";
    private static final String IS_ONLY_LIVE_BRANCHES_PARAMETER_NAME = "only-live-branches";
    private static final String FILTER_PARAMETER_DESCRIPTION = "If this is set, the service returns branches that contain the filter. The filter is case insensitive.";
    private static final String FILTER_PARAMETER_NAME = "filter";
    private static final String EXACT_BRANCHES_FILTER_PARAMETER_NAME = "exact-filter";
    private static final String EXACT_BRANCHES_FILTER_PARAMETER_DESCRIPTION = "If this is set the service checks whether the passed branches are contained in the currently live branches of the project and returns the ones that are.";
    @QueryParam(value="start-offset")
    @Parameter(description="The offset from which to start loading branches.")
    private int startOffset;
    @QueryParam(value="limit")
    @Parameter(description="The number of branches that should be returned.")
    private int limit;
    @QueryParam(value="only-live-branches")
    @Parameter(description="Whether only currently live branches should be returned.")
    @DefaultValue(value="false")
    private boolean isOnlyLive;
    @QueryParam(value="filter")
    @Parameter(description="If this is set, the service returns branches that contain the filter. The filter is case insensitive.")
    private String filter;
    @QueryParam(value="exact-filter")
    @Parameter(description="If this is set the service checks whether the passed branches are contained in the currently live branches of the project and returns the ones that are.")
    private List<String> exactBranchesFilter;

    public BranchesServiceRequestOptions() {
    }

    public BranchesServiceRequestOptions(int startOffset, int limit, boolean isOnlyLive) {
        this.startOffset = startOffset;
        this.limit = limit;
        this.isOnlyLive = isOnlyLive;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isOnlyLive() {
        return this.isOnlyLive;
    }

    public String getFilter() {
        return this.filter;
    }

    public List<String> getExactBranchesFilter() {
        return this.exactBranchesFilter;
    }
}

