/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.project.branch_tags.BranchTagsOptionContributor;
import com.teamscale.service.repository.BranchesInfo;
import com.teamscale.service.repository.BranchesServiceRequestOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

public interface IGlobalBranchesServiceApi {
    public static final String PROJECTS_PARAMETER = "projects";
    public static final String PROJECTS_PARAMETER_DESCRIPTION = "A list of project IDs. When not specified it defaults to \"all projects\"";
    public static final String GET_BRANCHES_SUMMARY = "Get multi project branches";
    public static final String GET_BRANCHES_DESCRIPTION = "Gets the branches for multiple projects as BranchesInfo";
    public static final String GET_FIRST_UI_BRANCH_NO_CONTENT_RESPONSE_DESCRIPTION = "No visible projects available.";
    public static final String GET_FIRST_UI_BRANCH_SUMMARY = "Get multi project first UI branch.";
    public static final String GET_FIRST_UI_BRANCH_DESCRIPTION = "Gets the branch to be displayed first in the UI for one of the specified projects.";
    public static final String GET_RECENT_BRANCHES_SUMMARY = "Get multi project recent branches";
    public static final String GET_RECENT_BRANCHES_DESCRIPTION = "Gets the recent branches for multiple projects.";

    @GET
    @RequiresNoPermission
    @Operation(summary="Get multi project branches", description="Gets the branches for multiple projects as BranchesInfo", tags={"Project"})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, BranchTagsOptionContributor.class})
    public BranchesInfo getGlobalBranchesGetRequest(@Parameter(description="A list of project IDs. When not specified it defaults to \"all projects\"") @QueryParam(value="projects") List<PublicProjectId> var1, @BeanParam BranchesServiceRequestOptions var2) throws StorageException;

    @GET
    @Path(value="default-branch")
    @RequiresNoPermission
    @Operation(summary="Get multi project first UI branch.", description="Gets the branch to be displayed first in the UI for one of the specified projects.", tags={"Project"}, responses={@ApiResponse(responseCode="204", description="No visible projects available.")})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public String getGlobalFirstUIBranchGetRequest(@Parameter(description="A list of project IDs. When not specified it defaults to \"all projects\"") @QueryParam(value="projects") List<PublicProjectId> var1) throws StorageException;

    @GET
    @Path(value="recent-branches")
    @RequiresNoPermission
    @Operation(summary="Get multi project recent branches", description="Gets the recent branches for multiple projects.", tags={"Project"})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public List<String> getGlobalRecentBranchesGetRequest(@Parameter(description="A list of project IDs. When not specified it defaults to \"all projects\"") @QueryParam(value="projects") List<PublicProjectId> var1) throws StorageException;
}

