/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.repository.RepositoryActivitySummary;
import com.teamscale.service.repository.RepositorySummary;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/projects/{project}/repository-summary")
public class RepositorySummaryService
extends ApiBase {
    public static final String END_TIMESTAMP_PARAMETER = "end-timestamp";
    private static final String CODE_COMMITS_ONLY = "code-commits-only";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get the repository summary", description="Provides summary information about the commit activity in a project.", tags={"Repository"})
    public RepositorySummary getRepositorySummary(@Parameter(description="Optional parameter, may be used to specify the last point in time to consider in the given query.") @QueryParam(value="end-timestamp") Long endTimestamp) throws StorageException {
        if (endTimestamp == null) {
            endTimestamp = System.currentTimeMillis();
        }
        RepositoryLogIndex repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        long newestCommitTimestamp = RepositorySummaryService.getNewestCommitTimestampBeforeEndTimestamp(repositoryLogIndex, endTimestamp);
        return new RepositorySummary(RepositorySummaryService.getFirstCommitTimestamp(repositoryLogIndex), newestCommitTimestamp);
    }

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get the repository summary", description="Provides summary information about the commit activity in a project.", tags={"Repository"})
    @Path(value="details")
    public RepositoryActivitySummary getRepositoryActivitySummary(@Parameter(description="Optional parameter, may be used to specify the last point in time to consider in the given query.") @QueryParam(value="end-timestamp") Long endTimestamp, @Parameter(description="Optional parameter, if set only RepositoryLogEntries that include at least one code commit are considered") @DefaultValue(value="false") @QueryParam(value="code-commits-only") boolean codeCommitsOnly) throws StorageException {
        if (endTimestamp == null) {
            endTimestamp = System.currentTimeMillis();
        }
        RepositoryLogIndex repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        return RepositorySummaryService.buildSummary(repositoryLogIndex, endTimestamp, codeCommitsOnly);
    }

    private static long getNewestCommitTimestampBeforeEndTimestamp(RepositoryLogIndex repositoryLogIndex, Long endTimestamp) throws StorageException {
        long newestCommitTimestamp = RepositorySummaryService.getNewestCommitTimestamp(repositoryLogIndex);
        if (endTimestamp != null) {
            return Math.min(endTimestamp, newestCommitTimestamp);
        }
        return newestCommitTimestamp;
    }

    public static RepositoryActivitySummary buildSummary(RepositoryLogIndex index, Long endTimestamp, boolean codeCommitsOnly) throws StorageException {
        HashMap<String, RepositoryLogEntryAggregate> firstLogEntryByRepositoryIdentifier = new HashMap<String, RepositoryLogEntryAggregate>();
        HashMap<String, RepositoryLogEntryAggregate> mostRecentRepositoryLogEntryMapping = new HashMap<String, RepositoryLogEntryAggregate>();
        List allEntries = index.getEntries(0L, Optional.ofNullable(endTimestamp).orElse(Long.MAX_VALUE).longValue());
        int entryCount = 0;
        HashSet<String> branches = new HashSet<String>();
        HashSet<String> contributors = new HashSet<String>();
        for (RepositoryLogEntryAggregate aggregateEntry : allEntries) {
            if (codeCommitsOnly && !RepositorySummaryService.includesCodeCommit((IRepositoryLogEntry)aggregateEntry)) continue;
            for (RepositoryLogEntry entry : aggregateEntry.getAllEntries()) {
                if (!firstLogEntryByRepositoryIdentifier.containsKey(entry.getRepositoryIdentifier())) {
                    firstLogEntryByRepositoryIdentifier.put(entry.getRepositoryIdentifier(), aggregateEntry);
                }
                mostRecentRepositoryLogEntryMapping.put(entry.getRepositoryIdentifier(), aggregateEntry);
                branches.add(entry.getCommit().getBranchName());
                contributors.add(entry.getAuthor());
            }
            ++entryCount;
        }
        RepositoryActivitySummary summary = codeCommitsOnly ? RepositorySummaryService.buildCodeCommitSummary(index, endTimestamp, firstLogEntryByRepositoryIdentifier, mostRecentRepositoryLogEntryMapping, entryCount, branches.size(), contributors.size()) : RepositorySummaryService.buildFullSummary(index, endTimestamp, entryCount, branches.size(), contributors.size());
        RepositorySummaryService.addRepositoryDetails(summary, firstLogEntryByRepositoryIdentifier, mostRecentRepositoryLogEntryMapping);
        return summary;
    }

    private static CommitCounts calculateCommitCounts(RepositoryLogIndex index, Long endTimestamp, boolean codeCommitsOnly) throws StorageException {
        ZonedDateTime end = Optional.ofNullable(endTimestamp).map(DateTimeUtils::atZone).orElseGet(DateTimeUtils::zonedNow);
        long last24Hours = end.minusHours(24L).toInstant().toEpochMilli();
        long last7Days = end.minusDays(7L).toInstant().toEpochMilli();
        long last14Days = end.minusDays(14L).toInstant().toEpochMilli();
        long last30Days = end.minusDays(30L).toInstant().toEpochMilli();
        long last90Days = end.minusDays(90L).toInstant().toEpochMilli();
        List entriesLast90Days = index.getEntries(last90Days, end.toInstant().toEpochMilli());
        int commitsLast24Hours = RepositorySummaryService.computeCommitCount(entriesLast90Days, last24Hours, codeCommitsOnly);
        int commitsLast7Days = RepositorySummaryService.computeCommitCount(entriesLast90Days, last7Days, codeCommitsOnly);
        int commitsLast14Days = RepositorySummaryService.computeCommitCount(entriesLast90Days, last14Days, codeCommitsOnly);
        int commitsLast30Days = RepositorySummaryService.computeCommitCount(entriesLast90Days, last30Days, codeCommitsOnly);
        int commitsLast90Days = (int)entriesLast90Days.stream().filter(RepositorySummaryService::includesCodeCommit).count();
        return new CommitCounts(commitsLast24Hours, commitsLast7Days, commitsLast14Days, commitsLast30Days, commitsLast90Days);
    }

    private static RepositoryActivitySummary buildCodeCommitSummary(RepositoryLogIndex index, Long endTimestamp, Map<String, RepositoryLogEntryAggregate> firstLogEntryByRepositoryIdentifier, Map<String, RepositoryLogEntryAggregate> mostRecentRepositoryLogEntryMapping, int entryCount, int branchCount, int contributorCount) throws StorageException {
        CommitCounts commitCounts = RepositorySummaryService.calculateCommitCounts(index, endTimestamp, true);
        long firstCommitTimestamp = ((RepositoryLogEntryAggregate)firstLogEntryByRepositoryIdentifier.entrySet().stream().min(Comparator.comparing(e -> ((RepositoryLogEntryAggregate)e.getValue()).getTimestamp())).get().getValue()).getTimestamp();
        long mostRecentCommitTimestamp = ((RepositoryLogEntryAggregate)mostRecentRepositoryLogEntryMapping.entrySet().stream().max(Comparator.comparing(e -> ((RepositoryLogEntryAggregate)e.getValue()).getTimestamp())).get().getValue()).getTimestamp();
        return new RepositoryActivitySummary(commitCounts.commitsLast24Hours, commitCounts.commitsLast7Days, commitCounts.commitsLast14Days, commitCounts.commitsLast30Days, commitCounts.commitsLast90Days, entryCount, firstCommitTimestamp, mostRecentCommitTimestamp, branchCount, contributorCount);
    }

    private static int computeCommitCount(List<RepositoryLogEntryAggregate> entries, long since, boolean codeCommitsOnly) {
        Stream<RepositoryLogEntryAggregate> repositoryLogEntryAggregateStream = entries.stream().filter(entry -> entry.getTimestamp() >= since);
        if (codeCommitsOnly) {
            return (int)repositoryLogEntryAggregateStream.filter(RepositorySummaryService::includesCodeCommit).count();
        }
        return (int)repositoryLogEntryAggregateStream.count();
    }

    private static RepositoryActivitySummary buildFullSummary(RepositoryLogIndex index, Long endTimestamp, int entryCount, int branchCount, int contributorCount) throws StorageException {
        CommitCounts commitCounts = RepositorySummaryService.calculateCommitCounts(index, endTimestamp, false);
        return new RepositoryActivitySummary(commitCounts.commitsLast24Hours, commitCounts.commitsLast7Days, commitCounts.commitsLast14Days, commitCounts.commitsLast30Days, commitCounts.commitsLast90Days, entryCount, RepositorySummaryService.getFirstCommitTimestamp(index), RepositorySummaryService.getNewestCommitTimestampBeforeEndTimestamp(index, endTimestamp), branchCount, contributorCount);
    }

    private static void addRepositoryDetails(RepositoryActivitySummary summary, Map<String, RepositoryLogEntryAggregate> firstLogEntryByRepositoryIdentifier, Map<String, RepositoryLogEntryAggregate> mostRecentRepositoryLogEntryMapping) {
        for (String repositoryIdentifier : firstLogEntryByRepositoryIdentifier.keySet()) {
            summary.addRepositoryRevisionRange(repositoryIdentifier, firstLogEntryByRepositoryIdentifier.get(repositoryIdentifier), mostRecentRepositoryLogEntryMapping.get(repositoryIdentifier));
        }
    }

    private static long getFirstCommitTimestamp(RepositoryLogIndex index) throws StorageException {
        return index.getOldestTimestamp();
    }

    private static long getNewestCommitTimestamp(RepositoryLogIndex index) throws StorageException {
        return index.getNewestTimestamp();
    }

    private static boolean includesCodeCommit(IRepositoryLogEntry entry) {
        return entry.getCommitTypes() != null && entry.getCommitTypes().contains(ECommitType.CODE_COMMIT);
    }

    private record CommitCounts(int commitsLast24Hours, int commitsLast7Days, int commitsLast14Days, int commitsLast30Days, int commitsLast90Days) {
    }
}

