/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing.graph;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.requirements_tracing.index.PolarionWorkItemLinkRoleIndex;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemLinkRole;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.issues.QueryServiceBase;
import com.teamscale.service.requirements_tracing.graph.SpecItemGraph;
import com.teamscale.wia.EDefaultSpecItemLinkRole;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/spec-items/graph")
public class SpecItemGraphService
extends QueryServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get spec item graph", description="Retrieves a graph representation of the performed spec item query.", tags={"Specification Items"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public SpecItemGraph getSpecItemGraph(@PathParam(value="project") PublicProjectId projectId, @Parameter(description="Issue query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        CommitDescriptor resolvedCommit = this.resolve(unresolvedCommit);
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)resolvedCommit);
        WorkItemHistoryIndexAggregation historyIndexAggregation = WorkItemHistoryIndexAggregation.forSpecItems((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        Set<TeamscaleIssueId> specItemIds = SpecItemGraphService.performQueryWithErrorHandling(query, historyIndexAggregation, historyAccessOption, StoredQueryIndex.EStoredQueryType.SPEC_ITEM, this.serviceInfo).stream().map(TeamscaleIssueId::fromInternalId).collect(Collectors.toSet());
        SpecItemGraph specItemGraph = new SpecItemGraph(this.getMergedLinkRoles(projectId));
        for (TeamscaleIssueId specItemId : specItemIds) {
            SpecItem specItem = (SpecItem)historyIndexAggregation.getById(specItemId);
            if (specItem == null) continue;
            specItemGraph.addNode(specItem);
            SpecItemGraphService.addLinksToGraph(specItemGraph, specItem, specItemIds);
        }
        return specItemGraph;
    }

    private Map<String, String> getMergedLinkRoles(PublicProjectId projectId) throws StorageException {
        HashMap<String, String> mergedLinkRoles = new HashMap<String, String>();
        for (EDefaultSpecItemLinkRole defaultSpecItemLinkRole : EDefaultSpecItemLinkRole.values()) {
            mergedLinkRoles.put(defaultSpecItemLinkRole.getLinkRoleName(), defaultSpecItemLinkRole.getMergedLinkRoleName());
            mergedLinkRoles.put(defaultSpecItemLinkRole.getOppositeLinkRoleName(), defaultSpecItemLinkRole.getMergedLinkRoleName());
        }
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectId, (IndexLayer)this.getIndexLayer());
        if (projectConfiguration == null) {
            return Collections.emptyMap();
        }
        ConnectorConfiguration polarionConnector = projectConfiguration.getConnectors().stream().filter(connector -> connector.isRequirementsManagementToolType(ERequirementsManagementTool.POLARION)).findFirst().orElse(null);
        if (polarionConnector != null) {
            mergedLinkRoles.putAll(this.getMergedLinkRolesFromPolarionConnector(polarionConnector));
        }
        return mergedLinkRoles;
    }

    private Map<String, String> getMergedLinkRolesFromPolarionConnector(ConnectorConfiguration polarionConnector) throws StorageException {
        PolarionWorkItemLinkRoleIndex workItemLinkRoleIndex = this.openGlobalIndex(PolarionWorkItemLinkRoleIndex.class);
        List linkRoles = workItemLinkRoleIndex.getWorkItemLinkRoles(polarionConnector.getOptionValue("Project ID"));
        HashSet includedLinkRoles = new HashSet();
        List.of(polarionConnector.getOptionValue("Included work item link roles").split(",")).forEach(linkRole -> includedLinkRoles.add(linkRole.strip()));
        HashMap<String, String> mergedLinkRoles = new HashMap<String, String>();
        for (PolarionWorkItemLinkRole linkRole2 : linkRoles) {
            CCSMAssert.isNotNull((Object)linkRole2.getName());
            CCSMAssert.isNotNull((Object)linkRole2.getOppositeName());
            if (includedLinkRoles.containsAll(List.of(linkRole2.getName(), linkRole2.getOppositeName()))) {
                String mergedLinkRole = linkRole2.getName() + "/" + linkRole2.getOppositeName();
                mergedLinkRoles.put(linkRole2.getName(), mergedLinkRole);
                mergedLinkRoles.put(linkRole2.getOppositeName(), mergedLinkRole);
                continue;
            }
            if (includedLinkRoles.contains(linkRole2.getName())) {
                mergedLinkRoles.put(linkRole2.getName(), linkRole2.getName());
                continue;
            }
            if (!includedLinkRoles.contains(linkRole2.getOppositeName())) continue;
            mergedLinkRoles.put(linkRole2.getOppositeName(), linkRole2.getOppositeName());
        }
        return mergedLinkRoles;
    }

    private static void addLinksToGraph(SpecItemGraph specItemGraph, SpecItem specItem, Set<TeamscaleIssueId> specItemIds) {
        List linkRoles = specItem.getLinkRoles();
        List linkedSpecItems = specItem.getLinkedSpecItems();
        CollectionUtils.forEach((Iterable)linkRoles, (Iterable)linkedSpecItems, (linkRole, linkedSpecItemIds) -> linkedSpecItemIds.forEach(linkedSpecItemId -> SpecItemGraphService.addLinkToGraph(specItemGraph, specItemIds, specItem.getId(), linkedSpecItemId, linkRole)));
        if (linkRoles.isEmpty() && specItem.getParentId().isPresent()) {
            LOGGER.info("No link roles available, but a parent for " + specItem.getId().getExternalId());
            ArrayList<TeamscaleIssueId> parentSpecItemIds = new ArrayList<TeamscaleIssueId>(specItem.getAdditionalParents());
            parentSpecItemIds.add((TeamscaleIssueId)specItem.getParentId().get());
            parentSpecItemIds.forEach(parentSpecItemId -> SpecItemGraphService.addLinkToGraph(specItemGraph, specItemIds, specItem.getId(), parentSpecItemId, EDefaultSpecItemLinkRole.PARENT.getLinkRoleName()));
        }
    }

    private static void addLinkToGraph(SpecItemGraph specItemGraph, Set<TeamscaleIssueId> specItemIds, TeamscaleIssueId specItemId, TeamscaleIssueId linkedSpecItemId, String linkRole) {
        if (specItemIds.contains(linkedSpecItemId)) {
            specItemGraph.addLink(specItemId, linkedSpecItemId, linkRole);
        }
    }
}

