/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.requirements_tracing.polarion;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ERequirementsManagementTool;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.requirements_tracing.connectors.polarion.PolarionRequirementsManagementToolConnectorDescriptor;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionServerException;
import com.teamscale.index.requirements_tracing.tools.polarion.client.exception.PolarionSessionException;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.requirements_tracing.polarion.result.PolarionWorkItemLinkRolesResult;
import com.teamscale.service.requirements_tracing.polarion.result.PolarionWorkItemTypeResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/spec-items/polarion/{accountName}/work-items")
public class PolarionWorkItemSchemaService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @PUT
    @Path(value="link-roles")
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="accountName")
    @Operation(summary="Get Polarion link roles", description="Returns the link roles for a Polarion project.", tags={"Specification Items", "Connectors"})
    public PolarionWorkItemLinkRolesResult getPolarionWorkItemLinkRoles(@RequestBody ConnectorConfiguration connectorConfiguration) {
        try {
            ConnectorDescriptorBase connector = this.loadConnector(connectorConfiguration);
            List workItemLinkRoles = ((PolarionRequirementsManagementToolConnectorDescriptor)connector).fetchPolarionWorkItemLinkRoles();
            return new PolarionWorkItemLinkRolesResult(workItemLinkRoles.stream().filter(linkRole -> !linkRole.getId().equals("parent")).collect(Collectors.toList()));
        }
        catch (ProjectConfigurationException | PolarionServerException | PolarionSessionException | InterruptedException | StorageException e) {
            String errorMessage = "Error while fetching link roles from Polarion";
            LOGGER.error(errorMessage, e);
            return new PolarionWorkItemLinkRolesResult(errorMessage + ":\n" + e.getMessage());
        }
    }

    @PUT
    @Path(value="types")
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_TOOL_ACCOUNTS, permissions={EBasicPermission.VIEW}, entityPathParameter="accountName")
    @Operation(summary="Get Polarion work item types", description="Returns the work item types for a Polarion project.", tags={"Specification Items", "Connectors"})
    public PolarionWorkItemTypeResult getPolarionWorkItemTypes(@RequestBody ConnectorConfiguration connectorConfiguration) {
        try {
            ConnectorDescriptorBase connector = this.loadConnector(connectorConfiguration);
            List workItemTypes = ((PolarionRequirementsManagementToolConnectorDescriptor)connector).fetchPolarionWorkItemTypes();
            return new PolarionWorkItemTypeResult(workItemTypes);
        }
        catch (ProjectConfigurationException | PolarionServerException | PolarionSessionException | InterruptedException | StorageException e) {
            String errorMessage = "Error while fetching link roles from Polarion";
            LOGGER.error(errorMessage, e);
            return new PolarionWorkItemTypeResult(errorMessage + ":\n" + e.getMessage());
        }
    }

    private ConfigurationInitializationContext getInitializationContext() throws StorageException {
        return new ConfigurationInitializationContext(this.getUser().getUsername(), this.getIndexLayer(), (IExternalCredentialsProvider)this.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
    }

    private ConnectorDescriptorBase loadConnector(ConnectorConfiguration connectorConfiguration) throws StorageException, ProjectConfigurationException {
        ConnectorDescriptorBase connector = ConnectorUtils.loadConnector((ConnectorConfiguration)connectorConfiguration, (ConfigurationInitializationContext)this.getInitializationContext(), null);
        if (!connector.getName().equals(ERequirementsManagementTool.POLARION.getReadableName())) {
            throw new ProjectConfigurationException("Service called with invalid connector descriptor: " + connector.getName());
        }
        return connector;
    }
}

