/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.code_change.ChangeRegions;
import com.teamscale.index.code_change.CodeChangeIndex;
import com.teamscale.index.code_change.CodeChangeUtils;
import com.teamscale.index.code_change.LineBasedChangeRegion;
import com.teamscale.index.code_change.UnresolvedBaseline;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/code-changes")
public class CodeChangeService
extends ApiBase {
    @GET
    @Path(value="{uniformPath}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get code changes", description="Retrieves information on code changes. Returns for all changes after the given baseline the timestamp of the last change in the corresponding region. Regions are line-based starting at 1 with both bounds being inclusive.", tags={"Source Code", "Delta"}, responses={@ApiResponse(responseCode="400", description="The uniform path is not a code or architecture path."), @ApiResponse(responseCode="404", description="The uniform path does not exist.")})
    public List<LineBasedChangeRegion> getCodeChanges(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @Parameter(description="The baseline name or baseline timestamp. Only changes that happened after this baseline are returned. If no baseline is given, all changes are reported.") @QueryParam(value="baseline") UnresolvedBaseline baseline, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon. This can be used to get a historic view on the changes.") @QueryParam(value="t") UnresolvedCommitDescriptor endCommit) throws StorageException {
        if (!uniformPath.isCodePath()) {
            throw new BadRequestException("Uniform path must point to a code file!");
        }
        String path = uniformPath.toString();
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(endCommit);
        TokenElementIndex contentIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        CodeChangeIndex codeChangeIndex = this.openProjectIndex(CodeChangeIndex.class, historyAccessOption);
        ChangeRegions changes = codeChangeIndex.getChangeRegion(path);
        TokenElementInfo elementInfo = contentIndex.getTokenElement(path);
        if (changes == null || elementInfo == null) {
            throw new NotFoundException("Element with path " + path + " does not exist!");
        }
        long baselineTimestamp = baseline.resolve((ProjectStorageSystem)this.getProjectStorageSystem());
        return CodeChangeUtils.filterAndConvertToLineRegions((ChangeRegions)changes, (String)elementInfo.getText(), (long)baselineTimestamp);
    }
}

