/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.resolution_strategy.ResourceResolutionStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/directories")
public class GlobalResourceContainerInfoService
extends ApiBase {
    @GET
    @Operation(summary="Get all project's directories", description="Returns global container info by merging container info from all projects.", tags={"Project", "Metrics"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_METRIC_THRESHOLD_CONFIGURATIONS})
    public ContainerInfo getGlobalContainerInfo(@Parameter(description="The uniform path of the parent directory.") @QueryParam(value="uniform-path") UniformPath path) throws StorageException {
        String pathOfParentDirectory = path.toString();
        ContainerInfo resultContainerInfo = this.getMergedContainerInfoOfAllProjects(pathOfParentDirectory);
        while (!pathOfParentDirectory.isEmpty() && resultContainerInfo.isEmpty()) {
            pathOfParentDirectory = UniformPathUtils.getParentPath((String)pathOfParentDirectory);
            resultContainerInfo = this.getMergedContainerInfoOfAllProjects(pathOfParentDirectory);
        }
        return resultContainerInfo;
    }

    private static HistoryAccessOption getHistoryAccessOptionForProjectAtHead(ProjectStorageSystem projectStorageSystem) throws StorageException {
        String defaultBranchName = ((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
        return HistoryAccessOption.readHead((String)defaultBranchName);
    }

    private ContainerInfo getMergedContainerInfoOfAllProjects(String uniformPath) throws StorageException {
        ContainerInfo resultContainerInfo = new ContainerInfo(uniformPath);
        for (ProjectInfo project : this.getPermissions().getVisibleProjects()) {
            GlobalResourceContainerInfoService.mergeContainerInfoOfCurrentProjectIntoResult(uniformPath, this.getIndexLayer(), resultContainerInfo, project);
        }
        return resultContainerInfo;
    }

    private static void mergeContainerInfoOfCurrentProjectIntoResult(String uniformPath, IndexLayer indexLayer, ContainerInfo resultContainerInfo, ProjectInfo project) throws StorageException {
        ContainerInfo projectContainerInfo = GlobalResourceContainerInfoService.getContainerInfoOfProject(indexLayer, project, uniformPath, uniformPath);
        GlobalResourceContainerInfoService.mergeContainerInfo(projectContainerInfo, resultContainerInfo);
        if (StringUtils.isEmpty((String)uniformPath)) {
            GlobalResourceContainerInfoService.addContainerAtRoot(indexLayer, resultContainerInfo, project, UniformPath.EType.NON_CODE);
            GlobalResourceContainerInfoService.addContainerAtRoot(indexLayer, resultContainerInfo, project, UniformPath.EType.ISSUE_QUERY);
            GlobalResourceContainerInfoService.addContainerAtRoot(indexLayer, resultContainerInfo, project, UniformPath.EType.TEST_IMPLEMENTATION);
            GlobalResourceContainerInfoService.addContainerAtRoot(indexLayer, resultContainerInfo, project, UniformPath.EType.TEST_EXECUTION);
            GlobalResourceContainerInfoService.addContainerAtRoot(indexLayer, resultContainerInfo, project, UniformPath.EType.TEST_QUERY);
            GlobalResourceContainerInfoService.addContainerAtRoot(indexLayer, resultContainerInfo, project, UniformPath.EType.SPEC_ITEM_QUERY);
            GlobalResourceContainerInfoService.addContainerAtRoot(indexLayer, resultContainerInfo, project, UniformPath.EType.CODE_SCOPES);
        }
    }

    private static void addContainerAtRoot(IndexLayer indexLayer, ContainerInfo resultContainerInfo, ProjectInfo project, UniformPath.EType uniformPathType) throws StorageException {
        String prefix = uniformPathType.getPrefix();
        ContainerInfo containerInfo = GlobalResourceContainerInfoService.getContainerInfoOfProject(indexLayer, project, prefix, prefix);
        if (containerInfo != null) {
            resultContainerInfo.insertOrUpdateChildContainer(prefix, prefix);
        }
    }

    private static ContainerInfo getContainerInfoOfProject(IndexLayer indexLayer, ProjectInfo project, String uniformPath, String uniformPathForContainerSelection) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(project);
        HistoryAccessOption historyAccessOption = GlobalResourceContainerInfoService.getHistoryAccessOptionForProjectAtHead((ProjectStorageSystem)projectStorageSystem);
        return ResourceResolutionStrategyFactory.getStrategy((UniformPath)UniformPathCompatibilityUtil.convert((String)uniformPathForContainerSelection), (ProjectStorageSystem)projectStorageSystem).getContainerInfoForPath(UniformPathCompatibilityUtil.convert((String)uniformPath), historyAccessOption);
    }

    private static void mergeContainerInfo(ContainerInfo projectContainerInfo, ContainerInfo resultContainerInfo) {
        if (projectContainerInfo == null) {
            return;
        }
        Set resultContainerInfoChildren = resultContainerInfo.getChildren();
        for (String projectChildEntry : projectContainerInfo.getChildren()) {
            GlobalResourceContainerInfoService.mergeContainerInfoEntry(projectChildEntry, projectContainerInfo, resultContainerInfoChildren, resultContainerInfo);
        }
    }

    private static void mergeContainerInfoEntry(String projectChildEntry, ContainerInfo projectContainerInfo, Set<String> resultContainerInfoChildren, ContainerInfo resultContainerInfo) {
        String projectChildEntryHash = projectContainerInfo.getHash(projectChildEntry);
        if (resultContainerInfoChildren.contains(projectChildEntry) && (resultContainerInfo.childIsAContainer(projectChildEntry) || projectChildEntryHash.startsWith("container:"))) {
            projectChildEntryHash = "container:";
        }
        resultContainerInfo.insertOrUpdateChildElementWithHash(projectChildEntry, projectChildEntryHash);
    }
}

