/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompilationCommand;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.ContentIndexSynchronizer;
import com.teamscale.index.resource.CppSystemIncludeDirectories;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.IndexAwareCPreprocessor;
import com.teamscale.index.resource.PreprocessorExpansionsIndex;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.element_details.InitialMacroDefinitionsDetail;
import com.teamscale.index.resource.element_details.PrependDirectivesDetail;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorRerunDefineTreesIndex;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.IncludedTokens;
import eu.cqse.check.framework.preprocessor.c.PreprocessorIncludeTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorMacroExpansionTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.algo.Diff;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFileUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

@Path(value="api/projects/{project}/preprocessor/debug/reparse-required-results")
public class PreprocessorReparseTriggerResultsDebugService
extends ApiBase {
    @GET
    @Path(value="by-timestamp-range")
    @Produces(value={"application/zip"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Verification of the results of the PreprocessorIncludeReparseTrigger", tags={"Debugging"}, description="This service checks the correctness of one of our preprocessor optimizations on the given project.\nFor each file where we determined that re-preprocessing the file is not necessary in a commit, the service does preprocess the file again and checks whether the preprocessed tokens really did not change.\nPreprocessing in this service is slower than in the normal analysis pipeline. Expect service runtimes of several hours or days.\nThis service (and the other service) have several configuration options to limit the scope of the correctness checking (e.g., to divide the commit history into chunks and reduce the time for each service call).\n\nThis service returns a zip file.\nFor each commit in which deviations between the stored (i.e., not recomputed in the commit) and recomputed preprocessor results were found, the zip file contains detail information for debugging.\nIf no deviations are found (i.e., everything is correct), the zip file contains only a \"no_problems_found.txt\".\n", responses={})
    public Response getDebugRepresentation(@Parameter(description="The lowest commit timestamp that will be considered by this analysis (inclusive). A zero or negative value means that all commits are analyzed.", required=false) @QueryParam(value="minimum-timestamp") long minTimestamp, @Parameter(description="The highest commit timestamp that will be considered by this analysis (inclusive). A zero or negative value means that all commits are analyzed.", required=false) @QueryParam(value="maximum-timestamp") long maxTimestamp, @Parameter(description="Return after first commit in which problems were found.", required=false) @QueryParam(value="fail-fast") boolean failFast) throws StorageException, IOException {
        ReparseRequiredIndex reparseRequiredIndex = this.openProjectIndex(ReparseRequiredIndex.class, null);
        Map filesThatDontNeedToBeReparsed = reparseRequiredIndex.computeFilesThatDontNeedToBeReparsed();
        filesThatDontNeedToBeReparsed.keySet().removeIf(commit -> commit.getTimestamp() < minTimestamp || maxTimestamp > 0L && commit.getTimestamp() > maxTimestamp);
        byte[] zipFileBytes = this.verifyReparseRequiredInCommits(filesThatDontNeedToBeReparsed, failFast);
        return ResponseUtils.getFileDownloadResponse((Object)zipFileBytes, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)"verificationResults.zip");
    }

    @GET
    @Path(value="by-batch")
    @Produces(value={"application/zip"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Verification of the results of the PreprocessorIncludeReparseTrigger", tags={"Debugging"}, description="This service checks the correctness of one of our preprocessor optimizations on the given project.\nFor each file where we determined that re-preprocessing the file is not necessary in a commit, the service does preprocess the file again and checks whether the preprocessed tokens really did not change.\nPreprocessing in this service is slower than in the normal analysis pipeline. Expect service runtimes of several hours or days.\nThis service (and the other service) have several configuration options to limit the scope of the correctness checking (e.g., to divide the commit history into chunks and reduce the time for each service call).\n\nThis service returns a zip file.\nFor each commit in which deviations between the stored (i.e., not recomputed in the commit) and recomputed preprocessor results were found, the zip file contains detail information for debugging.\nIf no deviations are found (i.e., everything is correct), the zip file contains only a \"no_problems_found.txt\".\n\nThis service divides the commits in the project history into batches. Only one batch is analyzed per service call.\nYou can configure how many commits are contained in a batch and which batch number should be analyzed.\nThis is meant to be used to break up long service calls that would otherwise be impossible (e.g., would take longer than a VPN login window).\n", responses={})
    public Response getDebugRepresentationBatch(@Parameter(description="The number of commits in a batch.", required=true) @QueryParam(value="batchSize") int batchSize, @Parameter(description="The index of the batch that should be analyzed. Starts at 0.", required=true) @QueryParam(value="batchIndex") int batchIndex, @Parameter(description="Return after first commit in which problems were found.", required=false) @QueryParam(value="fail-fast") boolean failFast) throws StorageException, IOException {
        ReparseRequiredIndex reparseRequiredIndex = this.openProjectIndex(ReparseRequiredIndex.class, null);
        Map filesThatDontNeedToBeReparsed = reparseRequiredIndex.computeFilesThatDontNeedToBeReparsed();
        List batches = Lists.partition((List)CollectionUtils.sort(filesThatDontNeedToBeReparsed.keySet(), CommitDescriptor::compareTo), (int)batchSize);
        if (batchIndex > batches.size()) {
            throw new IllegalArgumentException("Batch index " + batchIndex + " is out of range (max " + batches.size() + ")");
        }
        filesThatDontNeedToBeReparsed.keySet().removeIf(commit -> !((List)batches.get(batchIndex)).contains(commit));
        byte[] zipFileBytes = this.verifyReparseRequiredInCommits(filesThatDontNeedToBeReparsed, failFast);
        return ResponseUtils.getFileDownloadResponse((Object)zipFileBytes, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)"verificationResults.zip");
    }

    private byte[] verifyReparseRequiredInCommits(Map<CommitDescriptor, Set<String>> filesThatDontNeedToBeReparsed, boolean returnOnFirstCommitWithProblems) throws IOException, StorageException {
        boolean foundProblems = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)bos);){
            for (Map.Entry<CommitDescriptor, Set<String>> entry : filesThatDontNeedToBeReparsed.entrySet()) {
                CommitDescriptor commit = entry.getKey();
                Set<String> filesThatDontNeedToBeReparsedInCommit = entry.getValue();
                ConcurrentHashMap<String, IncludedTokens> includedTokensCache = new ConcurrentHashMap<String, IncludedTokens>();
                StringBuilder messagesForCommit = new StringBuilder();
                for (String uniformPath : filesThatDontNeedToBeReparsedInCommit) {
                    Pair<List<IToken>, List<PreprocessorTokenReplacement>> preprocessed = this.preprocessFile(commit, uniformPath, includedTokensCache);
                    List preprocessedTokens = (List)preprocessed.getFirst();
                    List replacements = (List)preprocessed.getSecond();
                    foundProblems |= this.analyzePreprocessedTokensDiff(uniformPath, commit, preprocessedTokens, messagesForCommit, zos);
                    foundProblems |= this.analyzePreprocessorReplacementsDiff(uniformPath, commit, replacements, messagesForCommit, zos);
                }
                if (!messagesForCommit.isEmpty()) {
                    ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(FileSystemUtils.toSafeFilename((String)commit.toServiceCallFormat()) + "/messages.txt"), (CharSequence)messagesForCommit);
                }
                if (!returnOnFirstCommitWithProblems || !foundProblems) continue;
                break;
            }
            if (!foundProblems) {
                ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)"no_problems_found.txt", (CharSequence)"Found no Problems");
            }
        }
        return bos.toByteArray();
    }

    private boolean analyzePreprocessedTokensDiff(String uniformPath, CommitDescriptor commit, List<IToken> preprocessedTokens, StringBuilder messagesForCommit, ZipArchiveOutputStream zos) throws StorageException, IOException {
        TokenElementIndex tokenElementIndex = this.openProjectIndex(TokenElementIndex.class, "content", HistoryAccessOption.readCommit((CommitDescriptor)commit));
        List storedTokens = tokenElementIndex.getTokenElement(uniformPath).getPreprocessedTokens();
        List storedTokensFormatted = CollectionUtils.map((Collection)storedTokens, PreprocessorReparseTriggerResultsDebugService::formatTokenForDiff);
        List computedTokensFormatted = CollectionUtils.map(preprocessedTokens, PreprocessorReparseTriggerResultsDebugService::formatTokenForDiff);
        Diff.Delta tokenDiff = Diff.computeDelta((List)computedTokensFormatted, (List)storedTokensFormatted);
        if (tokenDiff.getSize() > 0) {
            messagesForCommit.append("Token diff in file " + uniformPath + " in commit " + String.valueOf(commit));
            ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(FileSystemUtils.toSafeFilename((String)commit.toServiceCallFormat()) + "/" + uniformPath + "_tokensStored.txt"), (CharSequence)StringUtils.concat((Iterable)storedTokensFormatted, (String)"\n"));
            ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(FileSystemUtils.toSafeFilename((String)commit.toServiceCallFormat()) + "/" + uniformPath + "_tokensComputed.txt"), (CharSequence)StringUtils.concat((Iterable)computedTokensFormatted, (String)"\n"));
            ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(FileSystemUtils.toSafeFilename((String)commit.toServiceCallFormat()) + "/" + uniformPath + "_tokensDiff.txt"), (CharSequence)tokenDiff.toString());
            return true;
        }
        return false;
    }

    private static @NonNull String formatTokenForDiff(IToken token) {
        return token.getLineNumber() + ":" + token.getOffset() + " " + String.valueOf(token.getType()) + " " + token.getText();
    }

    private boolean analyzePreprocessorReplacementsDiff(String uniformPath, CommitDescriptor commit, List<PreprocessorTokenReplacement> replacements, StringBuilder messagesForCommit, ZipArchiveOutputStream zos) throws StorageException, IOException {
        List storedExpansionsFormatted;
        List storedExpansions = this.openProjectIndex(PreprocessorExpansionsIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit)).getExpansionsForUniformPath(uniformPath);
        List computedExpansionsFormatted = CollectionUtils.map(replacements, PreprocessorReparseTriggerResultsDebugService::formatReplacementForDiff);
        Diff.Delta expansionDiff = Diff.computeDelta((List)computedExpansionsFormatted, (List)(storedExpansionsFormatted = CollectionUtils.map((Collection)storedExpansions, PreprocessorReparseTriggerResultsDebugService::formatReplacementForDiff)));
        if (expansionDiff.getSize() > 0) {
            messagesForCommit.append("Expansion diff in file " + uniformPath + " in commit " + String.valueOf(commit));
            ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(FileSystemUtils.toSafeFilename((String)commit.toServiceCallFormat()) + "/" + uniformPath + "_expansionsStored.txt"), (CharSequence)StringUtils.concat((Iterable)storedExpansionsFormatted, (String)"\n"));
            ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(FileSystemUtils.toSafeFilename((String)commit.toServiceCallFormat()) + "/" + uniformPath + "_expansionsComputed.txt"), (CharSequence)StringUtils.concat((Iterable)computedExpansionsFormatted, (String)"\n"));
            ZipFileUtils.writeZipEntry((ZipArchiveOutputStream)zos, (String)(FileSystemUtils.toSafeFilename((String)commit.toServiceCallFormat()) + "/" + uniformPath + "_expansionsDiff.txt"), (CharSequence)expansionDiff.toString());
            return true;
        }
        return false;
    }

    private static String formatReplacementForDiff(PreprocessorTokenReplacement replacement) {
        StringBuilder builder = new StringBuilder();
        if (replacement instanceof PreprocessorIncludeTokenReplacement) {
            PreprocessorIncludeTokenReplacement includeTokenReplacement = (PreprocessorIncludeTokenReplacement)replacement;
            builder.append(replacement.originalTokensStartIndex).append("-").append(replacement.originalTokensEndIndex).append(" includes ").append(includeTokenReplacement.uniformPathOfIncludedFile).append("\n");
        } else if (replacement instanceof PreprocessorMacroExpansionTokenReplacement) {
            PreprocessorMacroExpansionTokenReplacement macroExpansionTokenReplacement = (PreprocessorMacroExpansionTokenReplacement)replacement;
            builder.append(replacement.originalTokensStartIndex).append("-").append(replacement.originalTokensEndIndex).append(" replaced with ").append(replacement.getReplacementTokens().size()).append(" tokens").append(" Expansion of macro defined in ").append(macroExpansionTokenReplacement.macroDefinitionUniformPath).append(":").append(macroExpansionTokenReplacement.macroDefinitionLineNumber).append("\n");
        } else {
            builder.append(replacement.originalTokensStartIndex).append("-").append(replacement.originalTokensEndIndex).append(" replaced with ").append(replacement.getReplacementTokens().size()).append(" tokens").append("\n");
        }
        return builder.toString();
    }

    private Pair<List<IToken>, List<PreprocessorTokenReplacement>> preprocessFile(CommitDescriptor commit, String uniformPath, ConcurrentMap<String, IncludedTokens> includedTokensCache) throws StorageException {
        BasicTokenElementIndex basicTokenElementIndex = (BasicTokenElementIndex)this.getProjectStorageSystem().openProjectIndex(BasicTokenElementIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        Object basicTokenElement = PreprocessorReparseTriggerResultsDebugService.loadElement(uniformPath, arg_0 -> ((BasicTokenElementIndex)basicTokenElementIndex).getTokenElement(arg_0));
        CodeScopeName codeScopeName = ((CodeScopeDetail)basicTokenElement.getFirstDetailOfType(CodeScopeDetail.class).get()).getCodeScopeName();
        IndexAwareCPreprocessor preprocessor = this.createPreprocessor((BasicTokenElementInfo)basicTokenElement, commit.toUnresolvedCommitDescriptor(), basicTokenElementIndex, codeScopeName, includedTokensCache);
        return PreprocessorReparseTriggerResultsDebugService.runPreprocessor(basicTokenElement, preprocessor);
    }

    private static Pair<List<IToken>, List<PreprocessorTokenReplacement>> runPreprocessor(BasicTokenElementInfo tokenElement, IndexAwareCPreprocessor preprocessor) {
        List tokens = ScannerUtils.getTokens((String)tokenElement.getFilteredText(), (ELanguage)tokenElement.getLanguage(), (String)tokenElement.getUniformPath());
        List replacements = preprocessor.computeReplacementsForTranslationUnit(tokenElement.getUniformPath(), tokens);
        List preprocessedTokens = CPreprocessingUtils.applyReplacements((List)replacements, (List)tokens);
        PreprocessorUtils.clearIfTokenNumberLimitExceeded((List)preprocessedTokens, (String)tokenElement.getUniformPath());
        return Pair.createPair((Object)preprocessedTokens, (Object)replacements);
    }

    private IndexAwareCPreprocessor createPreprocessor(BasicTokenElementInfo tokenElement, UnresolvedCommitDescriptor commit, BasicTokenElementIndex basicTokenElementIndex, CodeScopeName codeScopeName, ConcurrentMap<String, IncludedTokens> includedTokensCache) throws StorageException {
        PathLookupIndex pathLookupIndex = (PathLookupIndex)this.getProjectStorageSystem().openProjectIndex(PathLookupIndex.class, this.determineHistoryOption(commit));
        MetaIndex metaIndex = (MetaIndex)this.getProjectStorageSystem().openProjectIndex(MetaIndex.class, null);
        SystemIncludeFileCacheIndex systemIncludeFileCacheIndex = this.openGlobalIndex(SystemIncludeFileCacheIndex.class);
        SystemIncludeFileLookup systemIncludeFileLookup = SystemIncludeFileLookup.create((MetaIndex)metaIndex, (SystemIncludeFileCacheIndex)systemIncludeFileCacheIndex);
        FileIncludeLookup includeLookup = new FileIncludeLookup((IMatchingPathsLookup)pathLookupIndex, systemIncludeFileLookup);
        CompilationCommand compilationCommand = this.loadCompilationCommand(commit, tokenElement);
        PrependDirectivesDetail definitionsDetail = ContentIndexSynchronizer.buildPrependDirectivesDetail((BasicTokenElementInfo)tokenElement, (CompilationCommand)compilationCommand, this.getDefaultDefinitionsFromAnalysisProfile(tokenElement.getLanguage(), codeScopeName));
        IncludePathDetail includePathDetail = ContentIndexSynchronizer.buildIncludePathDetail((BasicTokenElementInfo)tokenElement, (CompilationCommand)compilationCommand, (CppSystemIncludeDirectories)((CppSystemIncludeDirectories)metaIndex.getValue(CppSystemIncludeDirectories.class)));
        InitialMacroDefinitionsDetail initialMacroDefinitionsDetail = ContentIndexSynchronizer.buildInitialMacroDefinitionsDetail((BasicTokenElementInfo)tokenElement, (PrependDirectivesDetail)definitionsDetail, (List)includePathDetail.getResolvedIncludeSearchPaths(), (FileIncludeLookup)includeLookup, new HashSet(), includedTokensCache, (BasicTokenElementIndex)basicTokenElementIndex);
        return new IndexAwareCPreprocessor(initialMacroDefinitionsDetail.definitions, includePathDetail.getResolvedIncludeSearchPaths(), includeLookup, new HashSet(), includedTokensCache, basicTokenElementIndex, true, true);
    }

    private List<IToken> getDefaultDefinitionsFromAnalysisProfile(ELanguage language, CodeScopeName codeScopeName) throws StorageException {
        AnalysisProfile embeddedProfile = ((ProjectConfiguration)this.openProjectIndex(MetaIndex.class, null).getValue(ProjectConfiguration.class)).getEmbeddedProfile(codeScopeName);
        if (embeddedProfile == null) {
            return Collections.emptyList();
        }
        String predefinedDirectivesText = embeddedProfile.getOptionValue("Predefined Preprocessor Macros");
        if (predefinedDirectivesText == null) {
            return Collections.emptyList();
        }
        return ScannerUtils.getTokens((String)predefinedDirectivesText, (ELanguage)language, (String)"default defines (analysis profile)");
    }

    private CompilationCommand loadCompilationCommand(UnresolvedCommitDescriptor commit, BasicTokenElementInfo tokenElement) throws StorageException {
        CompilationCommand compilationCommand = (CompilationCommand)this.openProjectIndex(CompileCommandIndex.class, this.determineHistoryOption(commit)).getCommands(Collections.singletonList(tokenElement.getUniformPath())).getFirst();
        if (compilationCommand == null || compilationCommand.getDefinitions() == null) {
            return CompilationCommand.getDefaultCompilationCommand();
        }
        return compilationCommand;
    }

    private static <T extends BasicTokenElementInfo> T loadElement(String uniformPath, FunctionWithException<String, T, StorageException> contentRetrievalFunction) throws StorageException {
        BasicTokenElementInfo element = (BasicTokenElementInfo)contentRetrievalFunction.apply((Object)(uniformPath = UniformPathUtils.cleanPath((String)uniformPath)));
        if (element == null) {
            throw new NotFoundException("No element of name " + uniformPath + " found!");
        }
        return (T)element;
    }

    @GET
    @Path(value="defineTree")
    @Produces(value={"text/plain"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Define tree that is the basis for determining whether a file must be preprocessed again in a commit", tags={"Debugging"}, description="This service returns the define tree of a given file in a given commit.\n", responses={})
    public String getDefineTree(@Parameter(description="The uniform path for which the define tree should be retrieved.", required=true) @QueryParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException, IOException {
        CommitDescriptor commit = this.resolve(unresolvedCommit);
        PreprocessorRerunDefineTreesIndex defineTreesIndex = this.openProjectIndex(PreprocessorRerunDefineTreesIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        Map defineTrees = defineTreesIndex.getDefineTrees(List.of(uniformPath.toString()));
        if (defineTrees.isEmpty()) {
            throw new NotFoundException("No define tree for file " + String.valueOf(uniformPath) + " in commit " + String.valueOf(commit) + " found!");
        }
        return ((PreprocessorRerunDefineTreesIndex.DefineTree)defineTrees.get(uniformPath.toString())).defineTree();
    }

    @GET
    @Path(value="defineTree-analyze")
    @Produces(value={"text/plain"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="This service returns whether the define tree changed in the given commit with respect to the parent commits", tags={"Debugging"}, description="This service returns whether the define tree changed in the given commit with respect to the parent commits.\n", responses={})
    public String analyzeDefineTreeChange(@Parameter(description="The uniform path for which the define tree should be retrieved.", required=true) @QueryParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommit) throws StorageException {
        CommitDescriptor commit = this.resolve(unresolvedCommit);
        PreprocessorRerunDefineTreesIndex defineTreesIndex = this.openProjectIndex(PreprocessorRerunDefineTreesIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        CommitDescriptorIndex commitIndex = this.openProjectIndex(CommitDescriptorIndex.class, null);
        ParentedCommitDescriptor parentedCommitDescriptor = commitIndex.getCommit(commit);
        Map<CommitDescriptor, Optional<PreprocessorRerunDefineTreesIndex.DefineTree>> parentDefineTrees = this.loadParentDefineTrees((UnmodifiableList<CommitDescriptor>)parentedCommitDescriptor.getParentCommits(), uniformPath);
        Map defineTrees = defineTreesIndex.getDefineTrees(List.of(uniformPath.toString()));
        if (defineTrees.isEmpty()) {
            throw new NotFoundException("No define tree for file " + String.valueOf(uniformPath) + " in commit " + commit.toServiceCallFormat() + " found!");
        }
        PreprocessorRerunDefineTreesIndex.DefineTree currentDefineTree = (PreprocessorRerunDefineTreesIndex.DefineTree)defineTrees.get(uniformPath.toString());
        StringBuilder response = new StringBuilder("Define Tree analysis for uniform path " + String.valueOf(uniformPath) + " in commit " + commit.toServiceCallFormat() + "\n");
        for (Map.Entry<CommitDescriptor, Optional<PreprocessorRerunDefineTreesIndex.DefineTree>> entry : parentDefineTrees.entrySet()) {
            if (entry.getValue().isEmpty()) {
                response.append("-----------------\nNo define-tree diff present in parent commit ").append(entry.getKey().toServiceCallFormat()).append("\n");
                continue;
            }
            Diff.Delta tokenDiff = Diff.computeDelta((Object[])StringUtils.splitLines((String)currentDefineTree.defineTree()), (Object[])StringUtils.splitLines((String)entry.getValue().get().defineTree()));
            if (tokenDiff.getSize() > 0) {
                response.append("-----------------\nDefine-tree diff to parent commit ").append(entry.getKey().toServiceCallFormat()).append("\n").append(tokenDiff).append("\n");
                continue;
            }
            response.append("-----------------\nNo diff in define-tree diff to parent commit ").append(entry.getKey().toServiceCallFormat()).append("\n");
        }
        return response.toString();
    }

    private Map<CommitDescriptor, Optional<PreprocessorRerunDefineTreesIndex.DefineTree>> loadParentDefineTrees(UnmodifiableList<CommitDescriptor> parentCommits, UniformPath uniformPath) throws StorageException {
        HashMap<CommitDescriptor, Optional<PreprocessorRerunDefineTreesIndex.DefineTree>> parentDefineTrees = new HashMap<CommitDescriptor, Optional<PreprocessorRerunDefineTreesIndex.DefineTree>>();
        for (CommitDescriptor parentCommit : parentCommits) {
            PreprocessorRerunDefineTreesIndex defineTreesIndex = this.openProjectIndex(PreprocessorRerunDefineTreesIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)parentCommit));
            Map defineTrees = defineTreesIndex.getDefineTrees(List.of(uniformPath.toString()));
            if (!defineTrees.isEmpty()) {
                parentDefineTrees.put(parentCommit, Optional.of((PreprocessorRerunDefineTreesIndex.DefineTree)defineTrees.get(uniformPath.toString())));
                continue;
            }
            parentDefineTrees.put(parentCommit, Optional.empty());
        }
        return parentDefineTrees;
    }
}

