/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.simulink;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.simulink.clones.SimulinkCloneFragment;
import com.teamscale.index.simulink.clones.SimulinkCloneFragmentIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/simulink/comparison")
public class SimulinkModelComparisonService
extends ApiBase {
    @GET
    @Operation(summary="Get comparison info", description="Returns the comparison information for two Simulink subsystems.", tags={"Simulink"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public SimulinkModelComparisonResult getSimulinkModelComparisonResult(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path of the left model in the comparison", required=true, allowEmptyValue=true) @QueryParam(value="left-path") UniformPath leftUniformPath, @Parameter(description="Uniform path of the right model in the comparison", required=true, allowEmptyValue=true) @QueryParam(value="right-path") UniformPath rightUniformPath, @Parameter(description="Location (ID) of the left subsystem element in the comparison", required=true, allowEmptyValue=true) @QueryParam(value="left-location") String leftLocation, @Parameter(description="Location (ID) of the right subsystem element in the comparison", required=true, allowEmptyValue=true) @QueryParam(value="right-location") String rightLocation) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        SimulinkCloneFragmentIndex fragmentIndex = this.openProjectIndex(SimulinkCloneFragmentIndex.class, historyAccessOption);
        List<String> rawKeys = Arrays.asList(SimulinkCloneFragment.buildRawKey((String)leftUniformPath.toString(), (String)leftLocation), SimulinkCloneFragment.buildRawKey((String)rightUniformPath.toString(), (String)rightLocation));
        List fragmentLists = fragmentIndex.getFragmentsForRawKeys(rawKeys);
        List leftFragments = (List)fragmentLists.get(0);
        List rightFragments = (List)fragmentLists.get(1);
        List leftHashes = CollectionUtils.map((Collection)leftFragments, SimulinkCloneFragment::getHash);
        List rightHashes = CollectionUtils.map((Collection)rightFragments, SimulinkCloneFragment::getHash);
        HashSet commonHashes = CollectionUtils.intersectionSet((Collection)leftHashes, (Collection[])new Collection[]{rightHashes});
        List<String> leftElementIds = SimulinkModelComparisonService.getIdsOfCommonFragments(leftFragments, leftLocation, commonHashes);
        List<String> rightElementIds = SimulinkModelComparisonService.getIdsOfCommonFragments(rightFragments, rightLocation, commonHashes);
        return new SimulinkModelComparisonResult(leftElementIds, rightElementIds);
    }

    private static List<String> getIdsOfCommonFragments(List<SimulinkCloneFragment> fragments, String location, Set<Long> commonHashes) {
        return fragments.stream().filter(fragment -> commonHashes.contains(fragment.getHash())).flatMap(fragment -> fragment.getBlockNames().stream()).distinct().map(name -> location + "/" + name).collect(Collectors.toList());
    }

    static class SimulinkModelComparisonResult {
        private static final String LEFT_IDS_PROPERTY = "leftIds";
        private static final String RIGHT_IDS_PROPERTY = "rightIds";
        @JsonProperty(value="leftIds")
        final List<String> leftIds;
        @JsonProperty(value="rightIds")
        final List<String> rightIds;

        @JsonCreator
        public SimulinkModelComparisonResult(@JsonProperty(value="leftIds") List<String> leftElementIds, @JsonProperty(value="rightIds") List<String> rightElementIds) {
            this.leftIds = leftElementIds;
            this.rightIds = rightElementIds;
        }
    }
}

