/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.roles;

import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.ISubject;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.SubjectRoleAssignments;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.permissions.PermissionFilterUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;

@Path(value="api/subject-role-assignments")
public class SubjectRoleAssignmentsService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_GLOBAL_ROLES})
    @Operation(summary="Get all role assignments for all groups and users (and assigned groups).", description="Returns a list of all subject role assignments.", tags={"Permission"})
    public List<List<SubjectRoleAssignments>> getAllSubjectRoleAssignments() throws StorageException {
        List<ISubject> subjects = this.getAllVisibleSubjects();
        ArrayList<List<SubjectRoleAssignments>> result = new ArrayList<List<SubjectRoleAssignments>>();
        HashMap<String, SubjectRoleAssignments> cachedAssignmentsBySubjectId = new HashMap<String, SubjectRoleAssignments>();
        UserGroupIndex groupIndex = this.openGlobalIndex(UserGroupIndex.class);
        for (ISubject subject : subjects) {
            ArrayList<ISubject> toCheck = new ArrayList<ISubject>();
            ArrayList<SubjectRoleAssignments> checkedAssignments = new ArrayList<SubjectRoleAssignments>();
            if (subject.getSubjectType() != ESubjectType.USER) {
                toCheck.add(subject);
                List<SubjectRoleAssignments> subjectRoleAssignments = this.determineSubjectRoleAssignments(toCheck);
                SubjectRoleAssignmentsService.cacheAssignments(subjectRoleAssignments, cachedAssignmentsBySubjectId);
                result.add(subjectRoleAssignments);
                continue;
            }
            User user = (User)subject;
            SubjectRoleAssignmentsService.processUserGroupAssignments(user, toCheck, checkedAssignments, cachedAssignmentsBySubjectId, groupIndex);
            List<SubjectRoleAssignments> subjectRoleAssignments = this.determineSubjectRoleAssignments(toCheck);
            SubjectRoleAssignmentsService.cacheAssignments(subjectRoleAssignments, cachedAssignmentsBySubjectId);
            checkedAssignments.addAll(subjectRoleAssignments);
            result.add(checkedAssignments);
        }
        return result;
    }

    private static void processUserGroupAssignments(User user, List<ISubject> toCheck, List<SubjectRoleAssignments> checkedAssignments, Map<String, SubjectRoleAssignments> cachedAssignmentsBySubjectId, UserGroupIndex groupIndex) throws StorageException {
        toCheck.add((ISubject)user);
        for (ISubject subjectToCheck : groupIndex.getGroupsForUser(user)) {
            SubjectRoleAssignments cached = cachedAssignmentsBySubjectId.get(subjectToCheck.getSubjectId());
            if (cached == null) {
                toCheck.add(subjectToCheck);
                continue;
            }
            checkedAssignments.add(cached);
        }
    }

    private static void cacheAssignments(List<SubjectRoleAssignments> subjectRoleAssignments, Map<String, SubjectRoleAssignments> cachedAssignmentsBySubjectId) {
        for (SubjectRoleAssignments assignment : subjectRoleAssignments) {
            cachedAssignmentsBySubjectId.put(assignment.getSubjectId(), assignment);
        }
    }

    @GET
    @Path(value="/{subjectType}/{subjectId}")
    @RequiresNoPermission(description="We have to do the permission check by hand as the needed permissions to display the own subject role assignments differ from the ones needed to view someone else's subject role assignments.")
    @Operation(summary="Get subject role assignments for a specific subject.", description="Returns a list of subject role assignments for a specific subject.", tags={"Permission"})
    public List<SubjectRoleAssignments> getSubjectRoleAssignments(@PathParam(value="subjectId") String subjectId, @PathParam(value="subjectType") String subjectType) throws StorageException {
        List<ISubject> subjects = this.determineSubjects(subjectId, subjectType);
        if (subjects.isEmpty()) {
            throw new BadRequestException("Unknown subject '" + subjectId + "'");
        }
        EBasicPermission permissionToCheck = this.determinePermissionToCheck(subjectId);
        this.checkPermissions(subjects.getFirst(), permissionToCheck);
        return this.determineSubjectRoleAssignments(subjects);
    }

    private EBasicPermission determinePermissionToCheck(String subjectId) {
        if (this.getUser().getSubjectId().equals(subjectId)) {
            return EBasicPermission.VIEW;
        }
        return EBasicPermission.EDIT;
    }

    private void checkPermissions(ISubject subject, EBasicPermission permissionToCheck) {
        if (subject.getSubjectType() == ESubjectType.USER) {
            this.getPermissions().checkBasicPermission(EBasicPermissionScope.USERS, subject.getSubjectId(), permissionToCheck);
        } else if (subject.getSubjectType() == ESubjectType.GROUP) {
            this.getPermissions().checkBasicPermission(EBasicPermissionScope.GROUPS, subject.getSubjectId(), permissionToCheck);
        } else {
            CCSMAssert.fail((String)("Unsupported subject type: " + subject.getSubjectType().readableName));
        }
    }

    private List<ISubject> determineSubjects(String subjectId, String subjectType) throws StorageException {
        CCSMAssert.isNotEmpty((String)subjectId, (String)"Parameter 'subjectId' must not be empty");
        CCSMAssert.isNotEmpty((String)subjectType, (String)"Parameter 'subjectType' must not be empty");
        if (subjectType.equals(ESubjectType.USER.readableName)) {
            UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
            User user = userIndex.getUser(subjectId);
            CCSMAssert.isNotNull((Object)user, (String)("No user named '" + subjectId + "' found."));
            return this.determineSubjectsForUser(user);
        }
        UserGroupIndex groupIndex = this.openGlobalIndex(UserGroupIndex.class);
        UserGroup group = groupIndex.getUserGroup(subjectId);
        CCSMAssert.isNotNull((Object)group, (String)("No group named '" + subjectId + "' found."));
        return List.of(group);
    }

    private List<ISubject> getAllVisibleSubjects() throws StorageException {
        ArrayList<ISubject> subjects = new ArrayList<ISubject>();
        subjects.addAll(this.getUserList());
        subjects.addAll(PermissionFilterUtils.getVisibleGroups(this.getPermissions(), this.openGlobalIndex(UserGroupIndex.class)));
        return subjects;
    }

    private List<User> getUserList() throws StorageException {
        List<User> users = PermissionFilterUtils.getVisibleUsers(this.getPermissions(), this.openGlobalIndex(UserIndex.class));
        for (User user : users) {
            UserUtils.sanitizeUser((User)user);
        }
        return users;
    }

    private List<ISubject> determineSubjectsForUser(User user) throws StorageException {
        UserGroupIndex groupIndex = this.openGlobalIndex(UserGroupIndex.class);
        ArrayList<ISubject> subjects = new ArrayList<ISubject>();
        subjects.add((ISubject)user);
        subjects.addAll(groupIndex.getGroupsForUser(user));
        return subjects;
    }

    private List<SubjectRoleAssignments> determineSubjectRoleAssignments(List<ISubject> subjects) throws StorageException {
        CCSMAssert.isNotEmpty(subjects, (String)"Parameter 'subjects' must not be empty");
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        return permissionIndex.getSubjectRoleAssignments(subjects);
    }
}

