/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.teamscale.service.framework.util.CsvServiceUtils;
import com.teamscale.service.search.SearchQuery;
import com.teamscale.service.search.SearchResultContainer;
import com.teamscale.service.search.result.CodeResultInfo;
import com.teamscale.service.search.result.CommitResultInfo;
import com.teamscale.service.search.result.FileResultInfo;
import com.teamscale.service.search.result.IssueResultInfo;
import com.teamscale.service.search.result.SearchResult;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.persistence.store.StorageException;

class SearchResultsCsvBuilder {
    SearchResultsCsvBuilder() {
    }

    static Response createCsv(SearchResultContainer results, SearchQuery.EQueryType source) throws StorageException {
        return switch (source) {
            default -> throw new MatchException(null, null);
            case SearchQuery.EQueryType.CODE -> SearchResultsCsvBuilder.exportCodeResultsCsv(results);
            case SearchQuery.EQueryType.FILES -> SearchResultsCsvBuilder.exportFileResultsCsv(results);
            case SearchQuery.EQueryType.COMMITS -> SearchResultsCsvBuilder.exportCommitResultsCsv(results);
            case SearchQuery.EQueryType.ISSUES -> SearchResultsCsvBuilder.exportIssueResultsCsv(results);
        };
    }

    private static Response exportIssueResultsCsv(SearchResultContainer results) throws StorageException {
        return CsvServiceUtils.createCsvResponse((String)"issue-results", csvListWriter -> {
            csvListWriter.writeHeader(new String[]{"Project", "Issue Id", "Status", "Subject"});
            for (SearchResult result : results.getResults()) {
                IssueResultInfo issueInfo = (IssueResultInfo)result.getInfos().get(0);
                csvListWriter.write(new Object[]{result.getProject(), issueInfo.getIssue().getId(), issueInfo.getIssue().getStatus(), issueInfo.getIssue().getSubject()});
            }
        });
    }

    private static Response exportCodeResultsCsv(SearchResultContainer results) throws StorageException {
        return CsvServiceUtils.createCsvResponse((String)"code-results", csvListWriter -> {
            csvListWriter.writeHeader(new String[]{"Project", "File", "Content"});
            for (SearchResult result : results.getResults()) {
                CodeResultInfo codeResultInfo = (CodeResultInfo)result.getInfos().get(0);
                csvListWriter.write(new Object[]{result.getProject(), result.getUrl(), codeResultInfo.getText()});
            }
        });
    }

    private static Response exportFileResultsCsv(SearchResultContainer results) throws StorageException {
        return CsvServiceUtils.createCsvResponse((String)"file-results", csvListWriter -> {
            csvListWriter.writeHeader(new String[]{"Project", "Path"});
            for (SearchResult result : results.getResults()) {
                FileResultInfo fileInfo = (FileResultInfo)result.getInfos().get(0);
                csvListWriter.write(new Object[]{result.getProject(), fileInfo.path});
            }
        });
    }

    private static Response exportCommitResultsCsv(SearchResultContainer results) throws StorageException {
        return CsvServiceUtils.createCsvResponse((String)"commit-results", csvListWriter -> {
            csvListWriter.writeHeader(new String[]{"Project", "Commit String", "Author", "Message"});
            for (SearchResult result : results.getResults()) {
                CommitResultInfo commitResultInfo = (CommitResultInfo)result.getInfos().get(0);
                csvListWriter.write(new Object[]{result.getProject(), commitResultInfo.getLogEntry().getCommit(), commitResultInfo.getLogEntry().getAuthor(), commitResultInfo.getLogEntry().getMessage()});
            }
        });
    }
}

