/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search.result;

import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.search.ESearchTokenSourceType;
import com.teamscale.index.search.SearchSource;
import com.teamscale.index.search.SearchToken;
import com.teamscale.service.search.result.CodeResultInfo;
import com.teamscale.service.search.result.SearchHitBase;
import com.teamscale.service.search.result.SearchHitLocation;
import com.teamscale.service.search.result.SearchResult;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class CodeSearchHit
extends SearchHitBase {
    private static final int NUM_LINES_FOR_PATH_HITS = 10;
    private static final int CONTEXT_LINES = 2;
    private final TokenElementIndex tokenElementIndex;

    public CodeSearchHit(SearchSource source, List<SearchToken> tokens, PublicProjectId project, TokenElementIndex tokenElementIndex) {
        super(source, tokens, project);
        this.tokenElementIndex = tokenElementIndex;
    }

    @Override
    public SearchResult createSearchResult() throws StorageException {
        String uniformPath = this.source.getSourceName();
        TokenElementInfo element = this.tokenElementIndex.getTokenElement(uniformPath);
        if (element == null) {
            return null;
        }
        boolean isCodeHit = ((SearchToken)this.tokens.get(0)).getSourceType() == ESearchTokenSourceType.CODE;
        LineOffsetConverter converter = new LineOffsetConverter(element.getFilteredText());
        int minLine = 1;
        int maxLine = 8;
        if (isCodeHit) {
            minLine = converter.getLine(Collections.min(this.tokens, Comparator.comparingInt(SearchToken::getOffset)).getOffset());
            maxLine = converter.getLine(Collections.max(this.tokens, Comparator.comparingInt(SearchToken::getOffset)).getOffset());
        }
        int startLine = Math.max(1, minLine - 2);
        int endLine = Math.min(converter.getLineCount(), maxLine + 2);
        if (endLine < minLine) {
            return null;
        }
        SearchResult searchResult = this.buildSearchResult(element, converter, startLine, endLine);
        searchResult.setFirstSearchHitLine(minLine);
        if (isCodeHit) {
            for (SearchToken token : this.tokens) {
                searchResult.addHit(new SearchHitLocation(token.getOffset(), token.getText().length()));
            }
        }
        return searchResult;
    }

    private SearchResult buildSearchResult(TokenElementInfo element, LineOffsetConverter converter, int startLine, int endLine) {
        SearchResult searchResult = new SearchResult(UniformPathUtils.getElementName((String)element.getUniformPath()), element.getUniformPath(), this.project);
        int startOffset = converter.getOffset(startLine);
        int endOffset = converter.getOffset(endLine + 1) - 1;
        CodeResultInfo codeInfo = new CodeResultInfo(element.getFilteredText().substring(startOffset, endOffset), startLine, startOffset);
        FormattedTokenElementInfo.insertStyledTokens((ELanguage)element.getLanguage(), (String)element.getText(), (List)CollectionUtils.filter((Collection)element.getTokens(), token -> token.getEndOffset() >= startOffset && token.getOffset() <= endOffset), codeInfo.tokens, codeInfo.styles, Collections.emptyList());
        for (int i = 0; i < codeInfo.tokens.size(); i += 3) {
            codeInfo.tokens.set(i, Math.max(0, codeInfo.tokens.get(i) - startOffset));
            codeInfo.tokens.set(i + 1, Math.max(0, codeInfo.tokens.get(i + 1) - startOffset));
        }
        searchResult.addInfo(codeInfo);
        return searchResult;
    }
}

